/**
 * @param {Number} activePreviewIndex - индекс активного превью
 */
BEM.DOM.decl({ name: 'b-banner-all-formats' }, {

    onSetMod: {
        js: function() {
            var previewBlock;

            if (this._getTabsPanes()) {
                previewBlock = this._getPreviewByTabIndex(this.params.activePreviewIndex);
            } else {
                previewBlock = this.findBlockByInterfaceInside('i-preview-tab-interface');
            }
            previewBlock && previewBlock.onEnable();

        }
    },

    /**
     * Обработчик события: переключен таб
     * @param {Event} e - событие
     * @param {Object} data - данные события
     * @param {Number} data.currentIndex - индекс текущей вкладки
     * @param {Number} data.previousIndex - индекс предыдущей вкладки
     * @private
     */
    _onTabChanged: function(e, data) {
        this._getPreviewByTabIndex(data.currentIndex).onEnable();
        this._getPreviewByTabIndex(data.prevIndex).onDisable();
    },

    /**
     * Возвращает блок, по индексу таба, в котором он расположен
     * @param {Number} index - индекс таба
     * @return {*|BEM}
     * @private
     */
    _getPreviewByTabIndex: function(index) {
        var pane = this._getTabsPanes().findPane().eq(index);

        this._previews || (this._previews = {});

        if (!this._previews[index]) {
            this._previews[index] = this.findBlockByInterfaceInside(pane, 'i-preview-tab-interface' )
        }

        return this._previews[index];
    },

    /**
     * Возвращает блок табов
     * @return {*|BEM}
     * @private
     */
    _getTabsPanes: function() {
        return this._tabsPanes || (this._tabsPanes = this.findBlockInside('tabs-panes'));
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('change', 'tabs', function(e, data) {
            this._onTabChanged(e, data);
        });

        return false;
    }

});
