/**
 * @param {Object} modelParams параметры модели кампании для данного блока
 * @param {String} modelParams.name
 * @param {String} modelParams.id
 * @param {Number} selectedLength число баннеров, выбранных для редактирования
 * @param {Array} variants массив с доступными значениями (По дефолту берется из константы AD_WARNINGS.age.variants)
 * @private
 */
block('b-banner-baby-food-labels-edit')(

    js()(function() {

        return { modelParams: this.ctx.modelParams };
    }),

    content()(function() {
        return {
            elem: 'form',
            variants: this.ctx.variants,
            selectedLength: this.ctx.selectedLength,
            mixBlock: this.ctx.mixBlock
        };
    }),

    elem('form').content()(function() {
        var ctx = this.ctx,
            mixBlock = ctx.mixBlock,
            selectedLength = ctx.selectedLength;

        return [
            {
                tag: 'h2',
                content: {
                    elem: 'header',
                    mix: { block: mixBlock, elem: 'header' },
                    content: iget2('b-banner-baby-food-labels-edit', 'izmenit-vozrastnoe-ogranichenie', 'Изменить возрастное ограничение')
                }
            },
            {
                elem: 'comment',
                mix: { block: mixBlock, elem: 'note' },
                content: iget2(
                    'b-banner-baby-food-labels-edit',
                    'izmenenie-budet-primeneno-tolko',
                    'Изменение будет применено только к объявлениям с доступным возрастным ограничением'
                )
            },
            {
                elem: 'comment',
                mix: [
                    { block: mixBlock, elem: 'note' },
                    { block: mixBlock, elem: 'bordered' }
                ],
                content: iget2('b-banner-baby-food-labels-edit', 'vybrano-obyavleniy-s', 'Выбрано объявлений: {foo}', {
                    foo: selectedLength
                })
            },
            {
                elem: 'container',
                mix: [
                    { block: mixBlock, elem: 'row' },
                    { block: mixBlock, elem: 'row-first' },
                    { block: mixBlock, elem: 'row-last' }
                ],
                variants: this.ctx.variants
            },
            {
                elem: 'errors',
                mix: { block: mixBlock, elem: 'row-errors' }
            },
            {
                elem: 'footer',
                mix: { block: mixBlock, elem: 'footer' },
                content: [
                    { elem: 'accept' },
                    { elem: 'cancel' }
                ]
            }
        ];
    }),

    elem('container').content()(function() {
        return {
            block: 'radiobox',
            name: 'baby_age_multiedit',
            value: this.ctx.variants[0],
            content: this.ctx.variants.map(function(age, index) {
                return {
                    elem: 'radio',
                    elemMods: { checked: index === 0 ? 'yes' : '' },
                    mix: [{
                        block: 'b-banner-baby-food-labels-edit',
                        elem: 'age-item'
                    }],
                    content: u.pluralize([iget2('b-banner-baby-food-labels-edit', 'mesyac', 'месяц'), iget2('b-banner-baby-food-labels-edit', 'mesyaca', 'месяца'), iget2('b-banner-baby-food-labels-edit', 'mesyacev', 'месяцев')], age),
                    controlAttrs: { value: age }
                };
            })
        };
    }),

    elem('accept').content()(function() {
        return {
            block: 'button',
            mods: { theme: 'action' },
            content: iget2('b-banner-baby-food-labels-edit', 'sohranit', 'Сохранить')
        };
    }),

    elem('cancel').content()(function() {
        return {
            block: 'button',
            content: iget2('b-banner-baby-food-labels-edit', 'otmena', 'Отмена')
        };
    })
);
