/**
 * @fires b-banner-callouts-popup#save Клик по "сохранить"
 * @fires b-banner-callouts-popup#cancel Клик по "отмена"
 */
BEM.DOM.decl({ block: 'b-banner-callouts-popup', implements: 'i-modal-popup-inner-block-interface' }, {

    /**
     * Были ли изменения
     * @returns {$.Deferred<Boolean>}
     */
    isChanged: function() {
        var deferred = $.Deferred();

        deferred.resolve(!!this._isChangedValue);

        return deferred.promise();
    },

    /**
     * Инициализация блока
     * @param {Object} params
     * @param {Object[]} params.callouts
     * @returns {BEM.DOM}
     */
    initialize: function(params) {
        this._getCalloutsSelector().reset({
            callouts: params.callouts
        });

        return this;
    },

    _isChangedValue: null,

    /**
     * Обработчик клика по любой кнопке внутри блока
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onButtonClick: function(e, data) {
        this.elem('save').is(e.block.domElem) && this._onSaveClick(e, data);
        this.elem('cancel').is(e.block.domElem) && this._onCancelClick(e, data);
    },

    _saveButton: null,

    /**
     * Обработчик клика по любой кнопке "Сохранить"
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onSaveClick: function(e, data) {
        this._saveButton || (this._saveButton = e.block);

        this.trigger('save', {
            value: this._getCalloutsSelector().val()
        });
    },

    /**
     * Возвращает инстанс кнопки "Сохранить"
     * @private
     */
    _getSaveButton: function() {
        return this._saveButton || (this._saveButton = this.findBlockOn('save', 'button'));
    },

    /**
     * Обработчик клика по любой кнопке "Отмена"
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onCancelClick: function(e, data) {
        this.trigger('cancel');
    },

    _calloutsSelector: null,

    /**
     * Возвращает инстанс блока выбора уточнения
     * @private
     */
    _getCalloutsSelector: function() {
        return this._calloutsSelector || (this._calloutsSelector = this.findBlockInside('body', 'b-callouts-selector'));
    },

    /**
     * Обработчик изменения блока уточнения
     * @param {jQuery.Event} e
     * @param {Object} data
     * @param {Boolean} data.isChanged Флаг наличия изменений
     * @param {Boolean} data.isValid Флаг валидности значения
     * @private
     */
    _onCalloutsSelectorChange: function(e, data) {
        this._calloutsSelector || (this._calloutsSelector = e.block);

        this._isChangedValue = data.isChanged;

        this._getSaveButton().setMod('disabled', data.isChanged && data.isValid ? '' : 'yes');
    },

    destruct: function() {
        BEM.DOM.destruct(this.domElem, true); // чистим внутренности

        return this.__base.apply(this, arguments);
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('click', 'button', function(e, data) {
                this._onButtonClick(e, data);
            })
            .liveInitOnBlockInsideEvent('change', 'b-callouts-selector', function(e, data) {
                this._onCalloutsSelectorChange(e, data);
            });

        return false;
    }

});
