BEM.DOM.decl('b-banner-callouts', {

    onSetMod: {
        js: function() {
            BEM.MODEL.on(this.params.modelParams, 'callouts', 'change', this._updateView, this);
        }
    },

    _bannerModel: null,

    /**
     * Возвращает модель баннера
     * @returns {BEM.MODEL}
     * @private
     */
    _getBannerModel: function() {
        return this._bannerModel || (this._bannerModel = BEM.MODEL.getOne(this.params.modelParams));
    },

    _switcherButton: null,

    /**
     * Возвращает инстанс кнопки, открывающей попап уточенений
     * @returns {BEM.DOM}
     * @private
     */
    _getSwitcher: function() {
        return this._switcherButton || (this._switcherButton = this.findBlockOn('switcher', 'button'));
    },

    /**
     * Обработчик изменения уточнений в баннере.
     * Если уточнения поменялись необходимо изменить текст кнопки и перерисовать список
     * @param {jQuery.Event} e
     * @private
     */
    _updateView: function(e) {
        this._bannerModel || (this._bannerModel = e.target.model);

        var callouts = this._getBannerModel().get('callouts');

        // меняем текст кнопки
        this._getSwitcher().setText(callouts.length ? iget2('b-banner-callouts', 'izmenit-111', 'Изменить') : iget2('b-banner-callouts', 'dobavit', 'Добавить'));

        // обновляем их список рядом с кнопкой
        BEM.DOM.update(this.elem('outcome'), $(BEMHTML.apply({
            block: 'b-banner-callouts',
            elem: 'outcome',
            callouts: callouts
        })));

        this.trigger('change');
    },

    /**
     * Обработчик клика по любой кнопке внутри блока
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onButtonClick: function(e, data) {
        this.elem('switcher').is(e.block.domElem) && this._onSwitcherClick(e, data);
    },

    /**
     * Обработчик клика по кнопке, открывающей попап уточенений
     * @param {jQuery.Event} e
     * @private
     */
    _onSwitcherClick: function(e) {
        this._switcherButton || (this._switcherButton = e.block);

        var popupDecorator = BEM.DOM.blocks['b-modal-popup-decorator'].create2(undefined, { bodyScroll: false }, $),
            subMan = BEM.create('i-subscription-manager'),
            calloutsSelector = popupDecorator
                .setPopupContent({ block: 'b-banner-callouts-popup' })
                .initialize({ callouts: this._getBannerModel().get('callouts') });

        subMan
            .on(calloutsSelector, 'save', function(e, data) {
                this._getBannerModel().set('callouts', data.value.callouts);

                popupDecorator.hide({ force: true });
            }, this)
            .on(calloutsSelector, 'cancel', function() {
                // DIRECT-59123: отмена закрывает попапы с force
                popupDecorator.hide({ force: true });
            }, this)
            .on(popupDecorator, 'close-blocked', function(e) {
                BEM.blocks['b-confirm'].open({
                    message: iget2('b-banner-callouts', 'izmeneniya-ne-budut-sohraneny', 'Изменения не будут сохранены. Продолжить?'),
                    fromPopup: popupDecorator.getPopup(),
                    onYes: function() {
                        popupDecorator.hide({ force: true });
                    }
                });
            }, this)
            .on(popupDecorator, 'close', function() {
                subMan.dispose();
                subMan.destruct();

                popupDecorator.destruct();
            }, this);

        popupDecorator.show();
    },

    destruct: function() {
        BEM.MODEL.un(this.params.modelParams, 'callouts', 'change', this._updateView, this);

        this.__base.apply(this, arguments);
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button', function(e, data) {
            this._onButtonClick(e, data);
        });

        return false;
    }

});
