block('b-banner-errata')(

    js()(function() {
        return {
            modelParams: this.ctx.modelParams
        };
    }),

    content()(function() {
        return [
            {
                elem: 'text',
                content: iget2('b-banner-errata', 'oshibki-i-opechatki-v', 'Ошибки и опечатки в объявлениях были исправлены автоматически.')
            },
            {
                elem: 'text',
                content: [
                    iget2('b-banner-errata', 'ishodnoe-obyavlenie', 'Исходное объявление'),
                    ':',
                    {
                        elem: 'preview',
                        content: [
                            {
                                elem: 'preview-title',
                                content: this.ctx.data.title
                            },
                            {
                                elem: 'preview-body',
                                content: this.ctx.data.body
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'text',
                content: iget2(
                    'b-banner-errata',
                    'v-lyuboy-moment-vy',
                    'В любой момент вы можете отключить функцию автоисправления текстов рекламных объявлений в {link}',
                    {
                        link: function(text) {
                            return {
                                block: 'link',
                                target: '_blank',
                                url: u.getUrl('userSettings', {
                                    ulogin: u.consts('ulogin')
                                }),
                                content: text
                            }
                        }(iget2('b-banner-errata', 'v-lyuboy-moment-vy-param-link', 'Настройках пользователя')),

                        context: 'link - Настройках пользователя'
                    }
                )
            },
            !!this.ctx.modelParams && {
                block: 'button',
                mods: { size: 'xs' },
                mix: [{
                    block: 'b-banner-errata',
                    elem: 'action-hide'
                }],
                content: iget2('b-banner-errata', 'bolshe-ne-pokazyvat', 'Больше не показывать')
            }
        ];
    })
);
