BEM.DOM.decl('b-banner-errata', {

    onSetMod: {

        loading: function(modName, modVal) {
            BEM.blocks['b-loader'].getInstance(this)[modVal ? 'show' : 'hide']();
        }

    },

    /**
     * Обработчик клика по кнопке
     * @param {jQuery.Event} e
     * @private
     */
    _onButtonClick: function(e) {
        var domElem = e.block.domElem;

        if (this.elem('action-hide').is(domElem)) {
            this.setMod('loading', 'yes');

            this._getRequest().get(
                { bid: this._getModelBanner().get('bid') },
                function() {
                    this._getModelBanner().set('before_moderation', {});
                    this.delMod('loading');
                    this._closePopup();
                }.bind(this),
                function() {
                    this.delMod('loading');
                    BEM.blocks['b-confirm'].alert(iget2('b-banner-errata', 'oshibka-zaprosa-poprobuyte-eshchyo', 'Ошибка запроса. Попробуйте ещё раз.'));
                }.bind(this)
            )
        }
    },

    _closePopup: function() {
        this.findBlockOutside('popup').hide();
    },

    /**
     * Создает запрос
     * @returns {BEM}
     * @private
     */
    _getRequest: function() {
        return this.request || (this.request = BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            type: 'GET',
            dataType: 'json',
            cache: false,
            data: { cmd: 'ajaxDisableAutocorrectionWarning' }
        }));
    },

    /**
     * Возвращает модель баннера
     * @returns {BEM.MODEL}
     * @private
     */
    _getModelBanner: function() {
        return this._modelBanner || (this._modelBanner = BEM.MODEL.getOrCreate(this.params.modelParams));
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button', function(e) {
            this._onButtonClick(e);
        });
    },

    /**
     * Создает и показывает попап с предыдущей версией баннера
     * @param {Object} options
     * @param {Object} [options.modelParams] Параметры модели баннера
     * @param {Object} options.data Данные баннера
     * @param {String} options.data.title Заголовок баннера до исправления опечаток
     * @param {String} options.data.body Описание баннера до исправления опечаток
     * @param {jQuery} options.owner DOM-элемент к которому должна указывать стрелка попапа
     * @static
     */
    show: function(options) {
        var popup = this.getPopup();

        popup.isShown() || popup.setContent(BEMHTML.apply({
            block: this.getName(),
            modelParams: options.modelParams,
            data: options.data
        }));

        popup.toggle(options.owner);
    },

    /**
     * Возвращает экземпляр попапа
     * @returns {BEM}
     */
    getPopup: function() {
        return BEM.blocks['b-shared-popup'].getInstance({
            adaptive: 'yes',
            'has-close': 'yes'
        });
    }

});
