BEM.DOM.decl({ block: 'b-banner-href', modName: 'can-edit-domain', modVal: 'yes' }, {
    onSetMod: {
        js: function() {

            this.__base();

            this._switchCtrl = this.findBlockOn('domain-switcher', 'button');

            this._switchCtrl.on('click', function() {
                this.toggleMod('with-domain', 'yes', '');
            }, this);

            this._subscriptionManager.wrap(this.findBlockOn('domain-input', 'input')).on('change', function(e) {
                //проверяем если только пользователь изменил инпут
                e.block.hasMod('focused') && !e.block.val() && this._setDomainFromHref();
            }, this);
        },

        'with-domain': function() {
            this._switchCtrl.delMod('focused');
        }
    },

    /**
     * Инициализация модели
     * @return {BEM.DOM}
     * @protected
     */
    _initModel: function() {
        this.__base.apply(this, arguments);

        this._subscriptionManager.wrap(this.model).on('domain', 'change', this._runModelCheck, this);

        return this;
    },

    /**
     * Выставляет домен из ссылки
     * @private
     */
    _setDomainFromHref: function() {
        this.model.set('domain', u.extractDomain(this.model.get('href')))
    },

    /**
     * Запускает проверку модели
     * Пришлось вынести в отдельный метод, так как в модифицированном блоке от i-glue модели в onSetMod js еще не существует
     * @private
     */
    _runModelCheck: function() {
        this.model.get('href') && this._checkModel();
    }

});
