block('b-banner-href')(

    elem('hidden')(

        tag()('input'),

        attrs()(function() {
            return {
                type: 'hidden',
                name: this.ctx.name || '',
                value: this.ctx.value || ''
            };
        })
    ),

    js()(function() {
        return {
            canEditDomain: this.ctx.canEditDomain,
            modelParams: this.ctx.modelParams,
            href: this.ctx.banner.href,
            protocol: this.ctx.banner.protocol
        };
    }),

    content()(function() {
        var banner = this.ctx.banner,
            ctxUrlLengthLimit = this.ctx.urlLengthLimit;

        return [
            {
                elem: 'row',
                content: [
                    {
                        block: 'b-href-control',
                        mix: {
                            block: 'b-banner-href',
                            elem: 'href'
                        },
                        mods: { inline: 'yes' },
                        protocol: banner.url_protocol,
                        href: banner.href,
                        limit: ctxUrlLengthLimit,
                        forceHttps: true,
                        protocolReadOnly: this.ctx.protocolReadOnly || this.mods.disabled === 'yes',
                        hrefReadOnly: this.ctx.hrefReadOnly || this.mods.disabled === 'yes'
                    }
                ]
            },
            this.ctx.canEditDomain ?
                {
                    elem: 'row',
                    mix: [{
                        elem: 'domain-row'
                    }],
                    content: [
                        {
                            block: 'input',
                            mix: [
                                {
                                    block: 'b-banner-href',
                                    elem: 'domain-input'
                                },
                                {
                                    block: 'b-banner-href',
                                    elem: 'model-field',
                                    js: { name: 'domain', type: 'input' }
                                },
                                { elem: 'domain' }
                            ],
                            name: 'domain',
                            value: banner.domain,
                            content: [
                                {
                                    elem: 'label',
                                    mix: [
                                        {
                                            block: 'b-banner-href',
                                            elem: 'label'
                                        },
                                        {
                                            block: 'b-banner-href',
                                            elem: 'domain-label'
                                        }
                                    ],
                                    content: iget2('b-banner-href', 'domen', 'домен')
                                },
                                { elem: 'control' }
                            ]
                        },
                        {
                            block: 'button',
                            mods: { pseudo: 'yes' },
                            mix: [{
                                block: 'b-banner-href',
                                elem: 'domain-switcher'
                            }],
                            content: [
                                {
                                    elem: 'message',
                                    tag: 'span',
                                    mix: [{
                                        block: 'b-banner-href',
                                        elem: 'hide-domain-message'
                                    }],
                                    content: iget2('b-banner-href', 'skryt', 'скрыть')
                                },
                                {
                                    elem: 'message',
                                    tag: 'span',
                                    mix: [{
                                        block: 'b-banner-href',
                                        elem: 'set-domain-message'
                                    }],
                                    content: iget2('b-banner-href', 'zadat-otobrazhaemyy-domen', 'задать отображаемый домен')
                                }
                            ]
                        }
                    ]
                } :
                {
                    elem: 'hidden',
                    mix: [
                        { elem: 'domain' },
                        {
                            elem: 'model-field',
                            js: {
                                name: 'domain',
                                type: 'native'
                            }
                        }
                    ],
                    name: 'domain',
                    value: banner.domain
                }
        ];
    })
);
