BEM.DOM.decl({ block: 'b-banner-href', baseBlock: 'i-glue' }, {

    onSetMod: {
        js: function() {
            this._subscriptionManager = BEM.create('i-subscription-manager');

            this.__base();

            this._canEditDomain = this.params.canEditDomain || false;
            this._initialHref = this.params.href || '';

            this._hrefControl = this.findBlockInside('href', 'b-href-control');
            this._hrefControl.on('state:changed', this._onChangeHref, this);

            this._subscriptionManager.wrap(this.model)
                .on('warnings-blocks-inited', function() {
                    //нужно для того чтобы событие `url-check-error` стригерилось после
                    // того как на него подпишется блок `b-banner-preview2-warnings`
                    this._checkModel(true);
                }, this)
                // При копировании обновляем поля
                // Важно - не обновляем при добавлении ошибок
                .on('change', function(e, field) {
                    this.trigger('change');

                    field.field != 'hrefHasErrors' &&
                        this._hrefControl.update(this.model.get('href'), this.model.get('url_protocol'));
                }, this);
        },

        disabled: function(modName, modVal) {
            this._hrefControl.toggleHref(modVal);
        }
    },

    /**
     * Обработчик события change на элементе href-input
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onChangeHref: function(e, data) {
        var val = this._hrefControl.val(),
            bannerModel = this.bannerModel,
            id = bannerModel.get('bid') + '_' + bannerModel.get('adgroup_id'),
            validatedData = data.validatedData,
            warning = validatedData && validatedData.warn,
            dataToUpdate,
            errors;

        if (this._hrefControl.getMod('state') == 'loading') {
            this._showWarnings([iget2('b-banner-href', 'idet-proverka-ssylki', 'Идет проверка ссылки')]);
            BEM.channel('banners-hrefs').trigger('state', { state: 'loading', id: id });
        } else {
            if (data.isReady) {
                if (val) {
                    dataToUpdate = {
                        domain_sign: validatedData.domain_sign,
                        domain_redir: validatedData.domain_redir,
                        domain_redir_sign: validatedData.domain_redir_sign,
                        market_rating: validatedData.market_rating,
                        url_protocol: val.protocol,
                        href: val.href,
                        // ошибок нет
                        hrefHasErrors: false
                    };

                    //если происходит копирование из предыдущего баннера, то нужно хранить домен, который скопировали
                    //в противном случае отображаемый домен нужно затереть ибо после изменения урла он протух
                    if (!this.model.hasCopyState()) {
                        dataToUpdate.domain = this._canEditDomain ? validatedData.domain : '';
                    }
                } else {
                    // при очистке href не сбрасываем протокол
                    dataToUpdate = {
                        domain_sign: '',
                        domain_redir: '',
                        domain_redir_sign: '',
                        market_rating: '',
                        href: '',
                        domain: '',
                        // ошибок нет
                        hrefHasErrors: false
                    };
                    this._clearWarnings();
                }

                this.model.setCopyState(false);
                this.model.update(dataToUpdate);
                this._checkModel(false);

                if (warning) {
                    errors = [warning];
                }
            } else {
                errors = data.alerts;
                // выставляем флаг про ошибки, чтобы при отправке урла
                // с ошибками выдавалаось правильное предупреждение на клиенте
                this.model.set('hrefHasErrors', true);
            }
            if (errors) {
                this._showWarnings(errors);
            }
            BEM.channel('banners-hrefs').trigger('state', { state: 'loaded', id: id });
        }
    },

    /**
     * Есть ли возможность редактировать домен
     */
    _canEditDomain: null,

    /**
     * Инициализация модели
     * @return {BEM.DOM}
     * @protected
     */
    _initModel: function() {
        this.bannerModel = BEM.MODEL.getOrCreate(this.params.modelParams);
        this.model = this.bannerModel.get('href_model');

        return this;
    },

    /**
     * Обновляет текстовки предупреждений
     * @param {Array} errArray массив ошибок
     * @returns {BEM}
     * @private
     */
    _showWarnings: function(errArray) {
        this.model.trigger('url-check-error', { messages: errArray });

        return this;
    },

    /**
     * Сбрасывает тексты предупреждений
     * @returns {BEM}
     * @private
     */
    _clearWarnings: function() {
        this.model.trigger('url-check-error', { messages: '' });

        return this;
    },

    /**
     * Проверяем модель на потенциальные ошибки
     *   - есть ли в ссылке параметры-плейсхолдеры
     *   - валидный ли домен
     *   - наличие редиректов
     *   - длину указанного домена
     *   - менялась ли ссылка
     * @param {Boolean} isInitialCheck флаг проверки при инициализации
     * @returns {BEM}
     * @private
     */
    _checkModel: function(isInitialCheck) {
        var errors = [],
            hasErrors;

        this.model.set('hrefHasErrors', false);

        this.model.get('isHrefHasParams') && errors.push('hrefParams');

        //@heliarian временно отключаем - DIRECT-45361
        //if (!!this.model.get('href')) {
        //    !!u.isUrl(this.model.get('domain')) ?
        //        this.model.isHrefRedirect() && errors.push('hrefDomain') :
        //        errors.push('hrefFormat');
        //}

        //@heliarian добавлено вместо предыдущих строк пока мы отключаем предупреждение "Ссылка с заголовка ведёт на другой домен"
        if (this._canEditDomain && !!this.model.get('href') && !u.isUrl(this.model.get('domain'))) {
            errors.push('hrefFormat');
            // выставляем флаг, что в модели есть ошибки
            this.model.set('hrefHasErrors', true);
        }

        this._canEditDomain && !this.model.isDomainLengthValid() &&
            errors.push('hrefLength') &&
        // выставляем флаг, что в модели есть ошибки
            this.model.set('hrefHasErrors', true);

        if (!isInitialCheck && this._canEditDomain && !this.model.get('isParentBannerNew')) {
            u.isUrl(this.model.get('href')) && this.model.isLinkChanged(this._initialHref) &&
                errors.push('hrefChanged');
        }

        hasErrors = errors.length && this.model.get('href').length;
        hasErrors ? this._showWarnings(errors) : this._clearWarnings();

        return this;
    },

    destruct: function() {
        this._subscriptionManager.dispose();

        return this.__base.apply(this, arguments);
    }
});
