block('b-banner-pic').mod('preview','yes')(

    content()(function() {
        var ctx = this.ctx,
            banner = ctx.banner;

        return [
            {
                elem: 'image',
                banner: banner
            },
            {
                elem: 'controls-container',
                content: [
                    {
                        elem: 'title',
                        elemMods: { preview: 'yes' },
                        banner: banner
                    },
                    {
                        elem: 'button',
                        elemMods: { preview: 'yes' },
                        banner: banner,
                        modelParams: ctx.modelParams,
                        cid: ctx.cid
                    }
                ]
            }
        ];
    }),

    elem('image').content()(function() {
        return [
            {
                elem: 'content',
                content: {
                    block: 'image',
                    attrs: {
                        src: this.ctx.banner.image ?
                            u.getImageUrl({
                                hash: this.ctx.banner.image,
                                mdsGroupId: this.ctx.banner.mds_group_id,
                                size: 'y300'
                            }, { fullPath: true }) : 'https://yastatic.net/lego/_/La6qi18Z8LwgnZdsAr1qy1GwCwo.gif'
                    },
                    mix: { block: 'b-banner-pic', elem: 'content-image' }
                }
            }
        ]
    }),

    elem('title').content()(function() {
        return [
            {
                elem: 'banner-pic-title',
                content: this.banner.image_name ?
                    u.hellipSplit(this.banner.image_name, 30, u.escapeHtmlSafe) : iget2('b-banner-pic', 'no-image', 'Изображение отсутствует')
            }
        ]
    })
);
