/**
 * Блок переключателя для открытия попапа выбора изображения для баннера
 *
 * @param {String} cid Идентификатор кампании
 * @param {Object} modelParams Объект с параметрами модели баннера
 * @param {Object} banner Объект с полями баннера, нужными для блока
 * @param {String} banner.modelId Идентификатор модели, должен совпадать с баннером
 * @param {String} banner.image Название файла изображения для баннера
 * @param {String} banner.image_name Хэш изображения для баннера
 */
block('b-banner-pic')(

    js()(function() {
        return {
            modelParams: this.ctx.modelParams
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            banner = ctx.banner;

        return [
            {
                elem: 'button',
                banner: banner,
                modelParams: ctx.modelParams,
                cid: ctx.cid
            },
            {
                elem: 'title',
                banner: banner
            },
            applyNext()
        ];
    }),

    elem('button').content()(function() {
        return [
            {
                block: 'b-outboard-controls',
                mix: [{
                    block: 'b-banner-pic',
                    elem: 'outboard'
                }],
                js: { popupId: 'pic-selector-control' },
                content: {
                    elem: 'switcher',
                    mix: [{
                        block: 'b-banner-pic',
                        elem: 'switcher'
                    }],
                    js: {
                        innerBlockParams: {
                            modelParams: this.ctx.modelParams,
                            cid: this.ctx.cid
                        }
                    },
                    switcherText: this.ctx.banner.image ? iget2('b-banner-pic', 'izmenit-111', 'Изменить') : iget2('b-banner-pic', 'dobavit', 'Добавить')
                }
            }
        ]
    }),

    elem('title').content()(function() {
        return [
            {
                elem: 'banner-pic-title',
                content: this.ctx.banner.image_name ? u.hellipSplit(this.ctx.banner.image_name, 30, u.escapeHtmlSafe) : ''
            }
        ]
    })
);
