BEM.DOM.decl({ block: 'b-banner-pic', baseBlock: 'i-glue' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._outboard = this.findBlockInside('b-outboard-controls');

            this._initEvents();
            this._updateUploadStatus();
        }
    },

    /**
     * Уничтожает блок
     * @returns {BEM.DOM}
     */
    destruct: function() {
        this._subscribe.dispose();

        return this.__base.apply(this, arguments);
    },

    /**
     * Инициализация события
     * @private
     */
    _initEvents: function() {
        var innerBlock = this._outboard.getInnerBlock();

        this._subscribe = BEM.create('i-subscription-manager')
            .on(this._outboard, 'hide', function() {
                this._outboard.toggleSwitchButton(false);
            }, this)
            .on(this.model, 'image_model', 'change', function() {
                this.trigger('change');
                this._updateUploadStatus();
            }, this);

        innerBlock && this._subscribe.on(innerBlock, 'selector-mode', function(e, type) {
            this._outboard.toggleSwitchButton(this._outboard.isShown() && type !== 'init');
        }, this);
    },

    /**
     * Обновляет статус загрузки изображения
     * Если изображение загружено, то будет выведено название файла, иначе текущий статус загрузки на сервер
     * @private
     */
    _updateUploadStatus: function() {
        var imageModel = this.model.get('image_model'),
            state = imageModel.get('image_processing_state'),
            titleElem = this.elem('banner-pic-title'),
            stateMod = ({
                pending: 'processing',
                wrong_image: 'wrong-image',
                error: 'error'
            })[state],
            status = ({
                pending: iget2('b-banner-pic', 'izobrazhenie-obrabatyvaetsya', 'изображение обрабатывается...'),
                error: iget2('b-banner-pic', 'ne-udalos-zagruzit-izobrazhenie', 'Не удалось загрузить изображение.'),
                wrong_image: iget2(
                    'b-banner-pic',
                    'oshibka-pri-obrabotke-izobrazheniya',
                    'Ошибка при обработке изображения. Попробуйте привести его к цветовому профилю sRGB или уменьшить размер.'
                )
            })[state];

        this.setMod(titleElem, 'state', stateMod || '');

        titleElem.html(status || u.hellipSplit(imageModel.get('image_name'), 30, u.escapeHtmlSafe));

        this._outboard.setSwitcherText(imageModel.get('image') ? iget2('b-banner-pic', 'izmenit-111', 'Изменить') : iget2('b-banner-pic', 'dobavit', 'Добавить'));

        imageModel.isChanged('image') && imageModel.fix();
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('init', 'b-outboard-controls');
    }
});
