/**
 * @property {String} this.ctx.device выбранный таб
 * @property {BannerPreviewFilterDeviceDecl[]} this.ctx.deviceList список табов
 */
block('b-banner-preview-filter2').elem('device-filter')(
    content()(function() {
        var displayList = ['desktop', 'mobile'],
            deviceList = this.ctx.deviceList.map(function(el) { return el.type; }),
            device = this.ctx.device || deviceList[0];

        return [
            {
                elem: 'text',
                content: iget2('b-banner-preview-filter2', 'na-ustroystve', 'На устройстве')
            },
            {
                block: 'radio-button',
                mix: {
                    block: 'b-banner-preview-filter2',
                    elem: 'device-filter-radio'
                },
                mods: {
                    size: 's'
                },
                name: 'device-filter',
                value: device,
                content: displayList.map(function(value) {
                    return {
                        elem: 'radio',
                        elemMods: {
                            'only-icon': 'yes',
                            disabled: (deviceList || displayList).indexOf(value) === -1 ? 'yes' : ''
                        },
                        attrs: {
                            title: u['b-banner-preview-filter2'].getDeviceTitle(value)
                        },
                        controlAttrs: {
                            value: value,
                            autocomplete: 'off'
                        },
                        content: {
                            block: 'icon',
                            mods: {
                                'size-16': value
                            },
                            mix: [{
                                block: 'radio-button',
                                elem: 'icon'
                            }]
                        }
                    };
                })
            }
        ];
    }),

    match(function() {
        return !this.ctx.deviceList || !this.ctx.deviceList.length;
    }).content()(''))
