/**
 * @property {Boolean} this.ctx.isTargetPresent отображается ли навигационный ответ
 * @property {Array<BannerPreviewFilterTabDecl|String>} this.ctx.target включен ли чекбокс навигационного ответа
 */
block('b-banner-preview-filter2').elem('target-answer')(
    attrs()(function() {
        return {
            title: iget2(
                'b-banner-preview-filter2',
                'vid-obyavleniya-v-pervom',
                'Вид объявления в первом спецразмещении в ответ на навигационный запрос'
            )
        };
    }),

    content()(function() {
        return [
            {
                elem: 'text',
                content: iget2('b-banner-preview-filter2', 'navigacionnyy-otvet', 'Навигационный ответ')
            },
            {
                block: 'check-button',
                mix: {
                    block: 'b-banner-preview-filter2',
                    elem: 'target-answer-toggle'
                },
                value: 'icon',
                mods: {
                    size: 's',
                    'only-icon': 'yes',
                    checked: this.ctx.target ? 'yes' : ''
                },
                content: {
                    block: 'icon',
                    mods: {
                        'size-16': 'target'
                    },
                    mix: [{
                        block: 'check-button',
                        elem: 'icon'
                    }]
                }
            }
        ];
    }),

    match(function() {
        return !this.ctx.isTargetPresent;
    }).content()(''))
