/**
 * @typedef {Object} BannerPreviewFilterState
 * @property {String} type название таба
 * @property { 'mobile' | 'desktop' } [device] выбранный девайс
 * @property {Boolean} [target] выбран ли чекбокс БНО
 */
/**
 * @typedef {Object} BannerPreviewFilterDeviceDecl
 * @property {String} type название типа девайса
 * @property {Boolean} isTargetPresent отображается ли кнопка переключения БНО
 */
/**
 * @typedef {Object} BannerPreviewFilterTabDecl
 * @property {String} type название таба
 * @property { { list: BannerPreviewFilterDeviceDecl[], default: String } } devices список девайсов на табе и выбранный по умолчанию девайс
 */
/**
 * @property {Object} {BannerPreviewFilterState} this.ctx.currentTab выбранный таб
 * @property {Array<BannerPreviewFilterTabDecl|String>} this.ctx.tabList список табов
 */
block('b-banner-preview-filter2')(
    def()(function() {
        var typeList = [],
            deviceList = [],
            device = null,
            deviceDecl,
            isTargetPresent,
            currentTab = this.ctx.currentTab;

        if (!currentTab) {
            // сначала ищем таб по умолчанию
            currentTab = u._.find(this.ctx.tabList, { isDefault: true });

            // если не нашли, то не очень красиво переключаем вид в базовый
            currentTab || (currentTab = this.ctx.tabList[0]);

            typeof currentTab == 'string' && (currentTab = { type: currentTab });
        }

        this.ctx.tabList.forEach(function(tabDecl) {
            tabDecl = typeof tabDecl == 'string' ? { type: tabDecl } : tabDecl;

            typeList.push(tabDecl.type);

            if (currentTab.type == tabDecl.type) {
                var tabDeclDevices = (tabDecl.devices || {});

                deviceList = tabDeclDevices.list || [];
                device = currentTab.device || tabDeclDevices['default'];
                deviceDecl = u['b-banner-preview-filter2']._getRespectiveDeviceDecl(deviceList, device);
                isTargetPresent = !!(deviceDecl || {}).isTargetPresent;
                currentTab.target = isTargetPresent && currentTab.target;
            }
        });

        return applyNext({
            typeList: typeList,
            deviceList: deviceList,
            isTargetPresent: isTargetPresent,
            target: !!currentTab.target,
            device: device,
            currentTab: currentTab
        });
    }),

    js()(function() {
        return {
            modelName: 'b-banner-preview-filter2',
            modelData: {
                tabList: this.ctx.tabList,
                type: this.currentTab.type,
                device: this.device,
                target: this.target
            }
        };
    }),

    content()(function() {
        return [
            {
                elem: 'type-filter',
                type: this.currentTab.type,
                typeList: this.typeList.length ? this.typeList : null
            },
            {
                elem: 'device-filter',
                device: this.device,
                deviceList: this.deviceList.length ? this.deviceList : null
            },
            {
                elem: 'target-answer',
                target: this.target,
                isTargetPresent: this.isTargetPresent
            },
            this.ctx.isPartnerAllFormatsEnabled && {
                elem: 'all-formats-button',
                type: this.currentTab.type
            }
        ];
    }),

    elem('type-filter').content()(function() {
        var texts = {
            base: iget2('b-banner-preview-filter2', 'bazovyy-vid', 'Базовый вид'),
            search: iget2('b-banner-preview-filter2', 'na-poiske', 'На поиске'),
            context: iget2('b-banner-preview-filter2', 'v-setyah', 'В сетях'),
            '0x0': iget2('b-banner-preview-filter2', 'adaptivnii', 'Адаптивный')
        };

        return {
            block: 'radio-button',
            mix: {
                block: 'b-banner-preview-filter2',
                elem: 'type-filter-radio'
            },
            mods: {
                size: 's'
            },
            name: 'type-filter',
            value: this.ctx.type,
            content: this.ctx.typeList.map(function(value) {
                return {
                    elem: 'radio',
                    controlAttrs: {
                        value: value,
                        autocomplete: 'off'
                    },
                    content: texts[value] || value
                };
            })
        };
    }),

    elem('text').tag()('span')
);
