/**
 * Генерируется при изменении значений внутренних контролов.
 * @event b-banner-preview-filter2#change
 * @event b-banner-preview-filter2#partner-all-formats-button:click
 * @type {Object}
 * @property {BannerPreviewFilterState} value текущее значение
 */

BEM.DOM.decl('b-banner-preview-filter2', {
    onSetMod: {
        js: function() {
            this._model = BEM.MODEL.create(this.params.modelName, this.params.modelData);

            this._model
                .on('type', 'change', function() {
                    this._renderDevices();
                    this._renderTarget();
                    this._renderPartnerAllFormats();
                }, this)
                .on('device', 'change', function() {
                    this._renderTarget();
                }, this)
                .on('type device target', 'change', $.debounce(function() {
                    if (this._isNowDestructing) return; //из-за отложенного вызова колбек может вызваться после того как блок был удален
                    this.trigger('change', { value: this.val() });
                }, 0), this);
        }
    },

    /**
     * @type {Boolean} флаг, который говорит о том что блок находится в процессе удаления
     */
    _isNowDestructing: false,

    /**
     * @override {BEM.DOM}
     */
    destruct: function() {
        this._isNowDestructing = true;

        this._model.destruct();
        return this.__base.apply(this, arguments);
    },

    /**
     * Возвращает текущее значение
     * @return {BannerPreviewFilterState}
     */
    val: function() {
        return this._model.getCurrentTab();
    },

    /**
     * Перерисовывает секцию с устройствами
     */
    _renderDevices: function() {
        var deviceParams = this._model.getDevicesParams();

        BEM.DOM.replace(this.findElem('device-filter'), BEMHTML.apply({
            block: 'b-banner-preview-filter2',
            elem: 'device-filter',
            device: deviceParams.device,
            deviceList: deviceParams.deviceList
        }));
    },

    /**
     * Перерисовывает секцию с навигационным ответом
     */
    _renderTarget: function() {
        var targetParams = this._model.getTargetParams();

        BEM.DOM.replace(this.findElem('target-answer'), BEMHTML.apply({
            block: 'b-banner-preview-filter2',
            elem: 'target-answer',
            isTargetPresent: targetParams.isTargetPresent,
            target: targetParams.target
        }));
    },

    /**
     * Создает попап с вкладками превью
     * @param {Object} options - опции превью
     * @param {Object} data - данные баннера
     */
    showBannerAllFormats: function(options, data) {
        BEM.blocks['i-banner-all-formats-opener'].showBannerAllFormats(options, data);
    },

    /**
     * Перерисовывает секцию с кнопкой всех видов РСЯ
     */
    _renderPartnerAllFormats: function() {
        BEM.DOM.replace(this.findElem('all-formats-button'), BEMHTML.apply({
            block: 'b-banner-preview-filter2',
            elem: 'all-formats-button',
            type: this._model.get('type')
        }));
    },

    /**
     * Обрабатывает события изменения контролов
     * @param {jQuery.Event} e
     * @param {String|Boolean} value значение радиобаттона/чекбаттона
     */
    _onControlChange: function(e, value) {
        var domElem = e.block.domElem,
            elemToField = {
                'type-filter-radio': 'type',
                'device-filter-radio': 'device',
                'target-answer-toggle': 'target'
            };

        Object.keys(elemToField).some(function(elemName) {
            if (this.findElem(elemName).is(domElem)) {
                this._model.set(elemToField[elemName], value);
            }
        }, this);
    },

    /**
     * Обрабатывает событие нажатия на кнопку 'Форматы'
     */
    _onBannerAllFormatsButtonClick: function() {
        this.trigger('banner-all-formats-button:click');
    }

}, {
    live: function() {
        this.liveInitOnBlockInsideEvent('change', 'radio-button', function(e, data) {
            this._onControlChange(e, e.block.val());
        });

        this.liveInitOnBlockInsideEvent('change', 'check-button', function(e, data) {
            this._onControlChange(e, e.block.isChecked());
        });

        this.liveInitOnBlockInsideEvent('click', 'button', function(e) {
            e.block.hasMod('partner-all-formats-button') && this._onBannerAllFormatsButtonClick();
        });
    }
});
