(function() {
    u.register({
        'b-banner-preview-filter2': {
            /**
             * Определяет устройство по умолчанию по баннерам
             * @param {{banner_type: String}[]} banners
             * @returns {String}
             */
            _getDefaultDevice: function(banners) {
                return banners.every(function(banner) { return banner.banner_type === 'mobile'; }) ?
                    'mobile' :
                    'desktop';
            },

            /**
             * Возвращает по типу устройства соответствующую декларацию из списка
             * @param {BannerPreviewFilterDeviceDecl[]} devicesDecls
             * @param {String} device
             * @returns {BannerPreviewFilterDeviceDecl|null}
             * @private
             */
            _getRespectiveDeviceDecl: function(devicesDecls, device) {
                return devicesDecls.filter(function(el) { return el.type == device }, this)[0] || null;
            },

            /**
             * Вычисляет, нужно ли отображать кнопку переключения БНО для "десктопного вида" на поиске
             * @param { {sitelinks: []} } banners
             * @returns {Boolean}
             */
            _calcTargetPresentForDesktop: function(banners) {
                return banners.some(function(banner) {
                    var sitelinks = banner.sitelinks || [];

                    return sitelinks.length == u.consts('SITELINKS_NUMBER') &&
                        banner.sitelinks.every(function(sitelink) {
                            return sitelink.description;
                        });
                });
            },

            /**
             * Вычисляет, нужно ли отображать кнопку переключения БНО для "мобильного вида" на поиске
             * @param { {sitelinks: []} } banners
             * @returns {Boolean}
             */
            _calcTargetPresentForMobile: function(banners) {
                return banners.some(function(banner) {
                    var sitelinks = banner.sitelinks || [];

                    return sitelinks.filter(function(sitelink) {
                        return sitelink.title.length;
                    }).length == u.consts('SITELINKS_NUMBER');
                });
            },

            /**
             * Возвращает набор табов для фильтра видов
             * @param {Object} options
             * @param {String} options.campMediaType
             * @param {String} [options.strategySearchName]
             * @param {String} [options.dontShowYacontext]
             * @param {{[image]: String, [creative]: Object}[]} options.banners
             * @return {String[]}
             */

            getTabsList: function(options) {
                switch (options.campMediaType) {
                    case 'text':
                        return (function() {
                            var searchStrategyIsOn = options.strategySearchName !== 'stop',
                                showYaContext = options.dontShowYacontext !== 'Yes',
                                hasOnlyImageAdsOrCpcVideo = options.banners
                                    .every(function(banner) {
                                        return u._.includes(['image_ad', 'cpc_video'], banner.ad_type);
                                    });

                            return [
                                'base',
                                !hasOnlyImageAdsOrCpcVideo && searchStrategyIsOn && {
                                    type: 'search',
                                    devices: {
                                        list: [
                                            {
                                                type: 'desktop',
                                                isTargetPresent: this._calcTargetPresentForDesktop(options.banners)
                                            },
                                            {
                                                type: 'mobile',
                                                isTargetPresent: this._calcTargetPresentForMobile(options.banners)
                                            }
                                        ],
                                        default: this._getDefaultDevice(options.banners)
                                    }
                                },
                                showYaContext && 'context'
                            ].filter(Boolean);
                        }).call(this);

                    case 'mobile_content':
                        var searchStrategyIsOn = options.strategySearchName !== 'stop',
                            showYaContext = options.dontShowYacontext !== 'Yes',
                            hasOnlyImageAdsOrCpcVideo = options.banners
                                .every(function(banner) {
                                    return u._.includes(['image_ad', 'cpc_video'], banner.ad_type)
                                });

                        return [
                            'base',
                            !hasOnlyImageAdsOrCpcVideo && searchStrategyIsOn && {
                                type: 'search',
                                devices: {
                                    list: []
                                },
                                isDefault: true,
                                isTargetPresent: false
                            },
                            showYaContext && 'context'
                        ].filter(Boolean);

                    case 'dynamic':
                        return options.strategySearchName !== 'stop' ?
                            [
                                'base',
                                {
                                    type: 'search',
                                    devices: {
                                        list: [
                                            {
                                                type: 'desktop',
                                                isTargetPresent: this._calcTargetPresentForDesktop(options.banners)
                                            },
                                            {
                                                type: 'mobile',
                                                isTargetPresent: this._calcTargetPresentForMobile(options.banners)
                                            }
                                        ],
                                        default: this._getDefaultDevice(options.banners)
                                    }
                                }
                            ] :
                            ['base'];

                    case 'performance':
                        // для ДМО в качестве списка табов выступают тэги размеров креативов
                        return ['base'].concat(u._.unique(options.banners.reduce(function(result, banner) {
                            return result.concat(banner.creative.sizeTag);
                        }, [])));

                    case 'mcbanner':
                    case 'content_promotion_video':
                        return ['base'];

                    case 'cpm_banner':
                    case 'cpm_deals':
                        return ['context'];

                    default:
                        return ['base'];
                }
            },

            /**
             * Определяет доступна ли к просмотру страница всех форматов баннера
             * @param {Object} options
             * @param {String} options.campMediaType
             * @param {Object[]} options.banners
             * @returns {Boolean}
             */
            isPartnerAllFormatsEnabled: function(options) {
                // пока кнопку всех форматов не показывем для смартов, РМП, cpm_banner, cpm_deals кампаниях
                // и когда первый баннер в группе ГО: DIRECT-61880 или cpc_video
                return !u._.includes(['image_ad', 'cpc_video'], u._.get(options, 'banners[0].ad_type')) &&
                    !u._.includes(['mobile_content', 'performance', 'cpm_banner', 'cpm_deals'], options.campMediaType);
            },

            /**
             * Возвращает описание для заданного типа устройств
             * @param {String} device
             * @returns {String}
             */
            getDeviceTitle: function(device) {
                switch (device) {
                    case 'desktop':
                        return iget2(
                            'b-banner-preview-filter2',
                            'vid-obyavleniya-na-nastolnyh',
                            'Вид объявления на настольных компьютерах, ноутбуках, планшетах'
                        );
                    case 'mobile':
                        return iget2('b-banner-preview-filter2', 'vid-obyavleniya-v-mobilnyh', 'Вид объявления в мобильных телефонах');
                    default:
                        return '';
                }
            }
        }
    });

}());
