BEM.MODEL.decl('b-banner-preview-filter2', {
    tabList: 'array', //массив их BannerPreviewFilterTabDecl
    // три поля ниже соответствуют типу {BannerPreviewFilterState}
    type: 'string',
    device: 'string',
    target: {
        type: 'boolean',
        default: false
    }
}, {
    /**
     * Возвращает параметры выбранного таба
     * @returns {BannerPreviewFilterTabDecl}
     */
    _getCurrentTabParams: function() {
        var currentTab = this.get('type'),
            result = !currentTab ?
                this.get('tabList')[0] :
                this.get('tabList').filter(function(tab) {
                    return tab == currentTab || tab.type == currentTab;
                }).pop();

        return typeof result == 'string' ? { type: result } : result;
    },

    /**
     * Возвращает выбранные значения
     * @returns {BannerPreviewFilterState}
     */
    getCurrentTab: function() {
        var tabParams = this._getCurrentTabParams(),
            device = this.get('device'),
            target = this.get('target'),
            res = {
                type: this.get('type') || tabParams.type
            };

        if (tabParams.devices) {
            if (u['b-banner-preview-filter2']._getRespectiveDeviceDecl(tabParams.devices.list, device)) {
                res.device = device;
            } else {
                res.device = tabParams.devices.default || u._.get(tabParams, 'devices.list[0].type');
            }

            if ((u['b-banner-preview-filter2']
                ._getRespectiveDeviceDecl(tabParams.devices.list, res.device) || {}).isTargetPresent) {

                res.target = target;
            }
        }

        return res;
    },

    /**
     * Возвращает список устройств и текущее устройство на выбранном табе
     * @returns { { current: String, deviceList: String[] } }
     */
    getDevicesParams: function() {
        var tabParams = this._getCurrentTabParams();

        return {
            device: this.get('device') || (tabParams.devices && tabParams.devices.default),
            deviceList: tabParams.devices && tabParams.devices.list
        };
    },

    /**
     * Возвращает состояние наличия и выбранность навигационного ответа
     * @returns { { target: Boolean, target: Boolean } }
     */
    getTargetParams: function() {
        var tabParams = this._getCurrentTabParams(),
            device = this.getCurrentTab().device,
            currentDeviceDecl = tabParams.devices &&
                u['b-banner-preview-filter2']._getRespectiveDeviceDecl(tabParams.devices.list, device) || {};

        return {
            isTargetPresent: currentDeviceDecl.isTargetPresent,
            target: this.get('target')
        };
    }
});
