BEM.DOM.decl({ block: 'b-banner-preview', modName: 'with-warnings', modVal: 'yes' }, {

    onSetMod: {
        js: function() {
            this.__base();

            if (this.params.modelParams) {
                this.hrefModel = this.model.get('href_model');

                this.hrefModel.on('url-check-error', function(e, data) {
                    this._hrefWarnings = data.messages;
                    this._showWarnings();
                }, this);

                this.model.on('geo-check-error', function(e, data) {
                    this._textWarning = data.messages;
                    this._showWarnings();
                }, this)
            }

        }
    },

    /**
     *
     * @param {Object} options
     * @param {Boolean} options.isBind
     * @private
     */
    _bindToModels: function(options) {
        var actionName = options && options.isBind ? 'on' : 'un';

        this.geoModel[actionName]('change', this._checkBannerDebounce, this);
        this.model[actionName]('title body', 'change', this._checkBannerDebounce, this);

        this.hrefModel[actionName]('url-check-error', function(e, data) {
            this._hrefWarnings = data.messages; this._checkBannerDebounce();
        }, this);

        return this;
    },

    destruct: function() {
        this._bindToModels({ isBind: false });
        this.__base.apply(this, arguments);
    },

    _warningTexts: null,

    /**
     * Возвращает объект с предупреждениями
     * @returns {Object}
     */
    warningTexts: function() {
        return this._warningTexts || (this._warningTexts = this.__self.warningTexts());
    },

    _getWarnings: function() {
        return [].concat(this._textWarning, this._hrefWarnings);
    },

    /**
     * Вывести предупреждения
     * @private
     */
    _showWarnings: function() {
        var warningsElem = this.elem('warnings'),
            errors = [];

        this._getWarnings().map(function(name) {
            if (name) {
                errors.push(
                    {
                        block: 'b-banner-preview',
                        elem: 'warning',
                        content: this.warningTexts()[name] || name
                    }
                )
            }
        }, this);

        if (errors.length) {
            BEM.DOM.update(warningsElem, BEM.HTML.build(errors));
            this.delMod(warningsElem, 'empty');
        } else {
            this.setMod(warningsElem, 'empty', 'yes');
        }
    }

}, {
    //переводы подключаются внизу страницы, так что warningTexts должно быть уже после декларации
    warningTexts: function() {
        return {
            hrefChanged: iget2(
                'b-banner-preview',
                'otobrazhaemaya-ssylka-izmenilas-proverte',
                'Отображаемая ссылка изменилась. Проверьте правильность.'
            ),
            hrefDomain: iget2('b-banner-preview', 'ssylka-s-zagolovka-vedyot', 'Ссылка с заголовка ведёт на другой домен'),
            hrefParams: iget2(
                'b-banner-preview',
                'ssylka-na-sayt-soderzhit',
                'Ссылка на сайт содержит параметры. Кириллические символы при подстановке в URL будут кодированы в utf-8. Убедитесь, что ваш сайт поддерживает эту кодировку.'
            ),
            hrefFormat: iget2('b-banner-preview', 'nepravilnyy-format-ssylki', 'Неправильный формат ссылки'),
            hrefLength: iget2(
                'b-banner-preview',
                'pri-pokaze-na-poiske',
                'При показе на поиске Яндекса домен может быть отображен в сокращенном виде (только 35 символов)'
            ),
            hrefTooLong: iget2('b-banner-preview', 'maksimalnaya-dlina-s-ssylki', 'Максимальная длина ({foo}) ссылки превышена.', {
                foo: u.consts('MAX_URL_LENGTH')
            })
        };
    }
});
