block('b-banner-preview')(
    def()(function() {
        var ctx = this.ctx,
            banner = ctx.banner || {},
            adWarnings = u.consts('AD_WARNINGS') || {},
            statusOpenStat = this.ctx.statusOpenStat,
            randPhrase = this.ctx.randPhrase,
            formattedRandPhrase = randPhrase && u.preview.formatPhrase(randPhrase.key_words);

        banner = u.bannerData({ banner: banner });

        banner.hrefFormatted = this.ctx.url || this.ctx.customUrl ||
            banner.href && u.getPreviewUrl(banner.href,
                u.getPreviewUrlParams(randPhrase, statusOpenStat === 'Yes', this.ctx.statusClickTrack)) || '';

        banner.ageVariants = (adWarnings.age && adWarnings.age.variants) || [18, 16, 12, 6, 0];
        banner.defaultAge = (adWarnings.age && adWarnings.age.default) || 18;
        banner.isTemplateBanner = ctx.isTemplateBanner || !!banner.is_template_banner ||
            banner.title && banner.title.indexOf('#') != -1 ||
            banner.body && banner.body.indexOf('#') != -1;

        banner.title = ctx.customTitle !== undefined ?
            ctx.customTitle :
            u.replaceTemplate(banner.title || '',
                u['b-banner-preview2'].calcTitleTemplateLimit((banner.title || '')),
                formattedRandPhrase);

        banner.body = ctx.customBody !== undefined ?
            ctx.customBody :
            u.replaceTemplate(banner.body || '',
                u['b-banner-preview2'].calcBodyTemplateLimit((banner.body || '')),
                formattedRandPhrase);

        banner.warnings = banner.warnings || banner.alerts;

        //sitelinks может прийти  [{title: '' }, {..}]
        if (banner.sitelinks && (!banner.sitelinks.length || !banner.sitelinks[0] || !banner.sitelinks[0].title)) {
            delete banner.sitelinks;
        }

        banner.sitelinks && banner.sitelinks.forEach(function(sitelink) {
            sitelink.hrefFormatted = u.formatHref(sitelink.href, statusOpenStat === 'Yes');
        }, this);

        return applyNext({
            banner: banner,
            isUpdatable: (this.mods.updatable == 'yes'),
            statusOpenStat: this.ctx.statusOpenStat,
            formattedRandPhrase: formattedRandPhrase
        });
    }),

    js()(function() {
        return {
            modelParams: this.ctx.modelParams,
            statusOpenStat: this.ctx.statusOpenStat,
            statusClickTrack: this.ctx.statusClickTrack,
            checkLinks: this.ctx.checklinks,
            customTitleHref: this.ctx.customTitleHref,
            publicIdentity: this.ctx.publicIdentity,
            isEasy: !!this.ctx.isEasy
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            banner = this.banner || {},
            bid = banner.bid,
            modelId = banner.modelId,
            cid = banner.cid,
            showAdditions = !ctx.hideAdditions && (!!banner.image || !!banner.sitelinks),
            adWarnings = u.consts('AD_WARNINGS') || {},
            bannerFlags = banner.hash_flags || {},
            //флаги баннера содержатся в общем массиве с предупреждениями
            showAlert = Object.keys(bannerFlags).some(function(key) {
                return key in adWarnings && !adWarnings[key].is_common_warn;
            });

        return [
            !ctx.hideBid && {
                elem: 'header',
                banner: banner,
                canViewImageId: this.ctx.canViewImageId,
                withMobile: this.ctx.withMobile,
                content: this.ctx.controls
            },
            [
                !ctx.hideTemplateWarning && banner.isTemplateBanner && {
                    block: 'icon-text',
                    mix: [{
                        block: 'b-banner-preview',
                        elem: 'warning',
                        elemMods: { type: 'template' }
                    }],
                    mods: { theme: 'info', size: 'xs' },
                    text: iget2('b-banner-preview', 'obyavlenie-soderzhit-shablon', 'Объявление содержит шаблон')
                },
                ctx.showThumbnail && banner.image && {
                    elem: 'thumb',
                    content: {
                        elem: 'image',
                        src: banner.image,
                        mdsGroupId: banner.mds_group_id,
                        alt: banner.title || ''
                    }
                },
                {
                    elem: 'links-wrap',
                    content: [{
                        block: 'link',
                        mix: [{
                            block: 'b-banner-preview',
                            elem: 'title'
                        }],
                        attrs: {
                            tabindex: -1,
                            target: !this.ctx.openInSameTab && '_blank'
                        },
                        content: banner.title ? banner.title : iget2('b-banner-preview', 'zagolovok-obyavleniya', 'Заголовок объявления'),
                        url: banner.hrefFormatted || undefined
                    }, (banner.sitelinks || this.isUpdatable) && !ctx.hideSitelinks && {
                        elem: 'sitelinks',
                        sitelinksNumber: u.consts('SITELINKS_NUMBER', this),
                        sitelinks: banner.sitelinks || []
                    },
                    {
                        elem: 'body', //todo: текст был изменен
                        content: (banner.body || iget2('b-banner-preview', 'tekst-vashego-obyavleniya-o', 'Текст вашего объявления о рекламе услуги или товара.'))
                            .replace(/(19\d\d|20[012]\d)[\s]+(\S\.)/g, '$1&nbsp;$2') //@see DIRECT-26940
                    },
                    {
                        elem: 'footer',
                        media: ctx.media,
                        showVCard: ctx.showVCard,
                        publicIdentity: ctx.publicIdentity,
                        domain: (ctx.domain || this.mods.updatable == 'yes' && iget2('b-banner-preview', 'domen', 'домен')),
                        hideVcardDetails: ctx.hideVcardDetails,
                        hideDomainParams: ctx.hideDomainParams,
                        isEasy: !!ctx.isEasy,
                        phrase: this.formattedRandPhrase
                    }]
                }
            ],
            !ctx.hideAdWarnings && showAlert && {
                elem: 'adv-alert',
                content: {
                    block: 'b-banner-adv-alert',
                    mods: { warnings: Object.keys(bannerFlags).length ? 'some' : 'zero' },
                    adWarnings: adWarnings,
                    warnings: banner.warnings,
                    modelId: modelId,
                    bid: bid,
                    flags: bannerFlags,
                    edit: ctx.isBannersEditable
                }
            },
            ctx.showAgeLabels && {
                block: 'b-banner-age-label',
                mix: [{
                    block: 'b-banner-preview',
                    elem: 'age-label'
                }],
                age: banner.age,
                modelParams: ctx.modelParams,
                //в просмотре превью групп нам не приходит canToggleAge в баннере
                canToggle: banner.canToggleAge || ctx.canToggleAge,
                bid: bid,
                variants: banner.ageVariants,
                defaultAge: banner.defaultAge
            },
            ctx.showGeo && {
                elem: 'geo-names',
                content: [
                    iget2('b-banner-preview', 'regiony-pokaza', 'Регионы показа'),
                    ': ',
                    {
                        block: 'b-group-regions',
                        geoNames: ctx.geoNames || '',
                        lang: banner.lang,
                        count: ctx.geoIds != 0 ?
                            (ctx.geoIds || '').split(',')
                                .filter(function(id) {
                                    return id > 0
                                })
                                .length || 1 : 8, //todo: const?
                        exceptions: banner.geo_exception || {}
                    }
                ]
            },
            showAdditions && {
                elem: 'additions',
                js: { banner: banner },
                content: [
                    iget2('b-banner-preview', 'dopolneniya', 'Дополнения:'),
                    ' ',
                    !!banner.image && {
                        block: 'link',
                        mix: [{
                            block: 'b-banner-preview',
                            elem: 'addition-link',
                            elemMods: { type: 'image' }
                        }],
                        js: { type: 'image' },
                        mods: { pseudo: 'yes' },
                        content: iget2('b-banner-preview', 'izobrazhenie', 'изображение')
                    },
                    !!(banner.image && banner.sitelinks) && ', ', !!banner.sitelinks && {
                        block: 'link',
                        mix: [{
                            block: 'b-banner-preview',
                            elem: 'addition-link',
                            elemMods: { type: 'sitelinks' }
                        }],
                        js: { type: 'sitelinks' },
                        mods: { pseudo: 'yes' },
                        content: (banner.sitelinks || []).some(function(link) { return !!link.description; }) ?
                            iget2('b-banner-preview', 'bystrye-ssylki-s-opisaniyami', 'быстрые ссылки с описаниями') :
                            iget2('b-banner-preview', 'bystrye-ssylki', 'быстрые ссылки')
                    }
                ]
            },
            !ctx.hideWarnings && {
                elem: 'warnings',
                elemMods: { empty: banner.warnings && banner.warnings.length ? '' : 'yes' },
                warnings: banner.warnings
            },
            ctx.showStatus && {
                elem: 'statuses',
                content: [{
                    block: 'b-banner-status',
                    mix: [{
                        block: 'b-banner-preview',
                        elem: 'status'
                    }],
                    banner: banner,
                    oldDiags: ctx.oldDiags,
                    hideOngoingShowsStatus: ctx.hideOngoingShowsStatus,
                    managerInfo: ctx.managerInfo,
                    agencyInfo: ctx.agencyInfo,
                    agencyManagerInfo: ctx.agencyManagerInfo,
                    userRole: ctx.userRole
                }]
            },
            ctx.actions && {
                elem: 'actions',
                actions: ctx.actions,
                banner: banner
            }
        ];
    }),

    elem('footer').content()(function() {
        var hasVCard = this.ctx.showVCard || this.banner.has_vcard;

        return [
            (hasVCard || this.isUpdatable) &&
            u.getUrl('showContactInfo', {
                bid: this.banner.bid,
                media: this.ctx.media,
                cid: this.banner.cid
            }) && {
                elem: 'vcard',
                elemMods: { visibility: !hasVCard ? 'hidden' : 'visible' },
                js: { bid: this.banner.bid },
                vcard: this.ctx.vcard || {},
                publicIdentity: this.ctx.publicIdentity,
                domain: this.ctx.domain,
                inactive: this.ctx.hideVcardDetails,
                loadVCardFromClient: this.banner.loadVCardFromClient,
                cid: this.banner.cid,
                bid: this.banner.bid
            },
            (!!this.banner.domain || this.isUpdatable) && {
                elem: 'domain',
                domain: this.banner.domain || iget2('b-banner-preview', 'domen', 'домен'),
                hrefHasParams: !this.ctx.hideDomainParams && u.hasHrefParams(this.banner.href),
                showTooltip: !this.ctx.isEasy,
                displayHref: this.banner.display_href,
                phrase: this.ctx.phrase
            }
        ];
    }),

    elem('sitelinks').content()(function() {
        var sitelinks = this.banner.sitelinks,
            sitelinksNumber;

        if (!sitelinks || !sitelinks.length) {
            sitelinks = [];
            sitelinksNumber = this.ctx.sitelinksNumber;

            for (var i = 0; i < sitelinksNumber; i++)
                sitelinks.push({
                    title: iget2('b-banner-preview', 'tekst-ssylki-no-s', 'Текст ссылки № {foo}', {
                        foo: i + 1
                    }),
                    href: '#'
                });
        }

        return sitelinks.map(function(sitelink, i) {
            return {
                elem: 'sitelink',
                elemMods: {
                    num: i,
                    first: i == 0 ? 'yes' : '',
                    last: i == sitelinks.length - 1 ? 'yes' : ''
                },
                sitelink: sitelink
            }
        });
    }),

    elem('sitelink')(
        tag()('a'),
        attrs()(function() {
            var attrs = {};

            attrs.href = this.ctx.sitelink.hrefFormatted;
            attrs.target = '_blank';

            return attrs;
        }),

        content()(function() {
            return u.escapeHTML(this.ctx.sitelink.title);
        })),

    elem('domain')(
        tag()('span'),
        content()(function() {
            var displayHref = this.ctx.displayHref &&
                u.replaceTemplate(
                    this.ctx.displayHref,
                    u.consts('MAX_DISPLAY_HREF_LENGTH'),
                    u.preview.prettifyDisplayHref(this.ctx.phrase),
                    null);

            displayHref = displayHref ? this.ctx.domain + '/' + displayHref : this.ctx.domain;

            return [
                u.escapeHTML(u.hellipCut(displayHref, 35, '...')),
                this.ctx.hrefHasParams && [
                    '&nbsp;/&nbsp;',
                    {
                        elem: 'domain-params-warning'
                    },
                    this.ctx.showTooltip && {
                        block: 'b-help-link',
                        mods: { type: 'modal' },
                        stretched: true,
                        url: u.getHelpUrl('url-tags')
                    }
                ]
            ];
        })),

    elem('domain-params-warning').attrs()(function() {
        return {
            title: iget2('b-banner-preview', 'ssylka-obyavleniya-soderzhit-parametry', 'Ссылка объявления содержит параметры.'),
            alt: iget2('b-banner-preview', 'ssylka-obyavleniya-soderzhit-parametry', 'Ссылка объявления содержит параметры.')
        };
    }),

    elem('vcard').def()(function() {
        return applyCtx({
            block: 'b-modal-popup-opener',
            mods: { decoration: 'yes' },
            mix: [{
                block: 'b-banner-preview',
                elem: 'vcard',
                elemMods: this.elemMods
            }],
            inactive: this.ctx.inactive,
            useNativeWindow: true,
            windowParams: { height: 750 },
            url: this.ctx.loadVCardFromClient ?
                null : this.ctx.publicIdentity ?
                u.getUrl('showContactInfo', {
                    public_identity: this.ctx.publicIdentity
                }) : this.ctx.bid && this.ctx.cid && u.getUrl('showContactInfo', {
                    bid: this.ctx.bid,
                    cid: this.ctx.cid
                }),
            text: iget2('b-banner-preview', 'adres-i-telefon', 'Адрес и телефон')
        });
    }),

    elem('image')(
        tag()('img'),
        attrs()(function() {
            var ctx = this.ctx;

            return ctx.attrs || {
                src: ctx.src && ctx.src != 'default' ?
                    u.getImageUrl({ mdsGroupId: ctx.mdsGroupId, hash: ctx.src, size: 'x90' }) :
                    '/data3/desktop.blocks/b-banner-preview/b-banner-preview__image_type_default.png',
                alt: ctx.alt
            };
        })),

    elem('warnings').content()(function() {
        return [
            this.banner.warnings && this.banner.warnings.map(function(warning) {
                return {
                    block: 'b-banner-preview',
                    elem: 'warning',
                    content: [warning, '. ']
                };
            })
        ];
    }),

    elem('actions').content()(function() {
        var ctx = this.ctx,
            actions = ctx.actions,
            banner = this.banner;

        return [
            actions && actions.stopAndRemoderate && banner.statusModerate != 'New' && {
                block: 'link',
                attrs: { target: '_blank' },

                mix: [{
                    block: 'b-banner-preview',
                    elem: 'stop-and-remoderate'
                }],
                url: u.getUrl('stopAndRemoderateBanner', {
                    bid: banner.bid,
                    bids: banner.bid,
                    cid: banner.cid
                }),
                content: iget2('b-banner-preview', 'ostanovit-i-peremoderirovat', 'Остановить и перемодерировать')
            }
        ];
    }),

    elem('vcard-form')(
        tag()('form'),
        attrs()({
            action: '/registered/main.pl',
            method: 'POST',
            target: 'ContactInfoPopup'
        }),
        content()(function() {
            return Object.keys(this.ctx.data).map(function(fieldName) {
                return {
                    tag: 'input',
                    attrs: {
                        type: 'hidden',
                        name: fieldName,
                        value: this.ctx.data[fieldName]
                    }
                }
            }, this);
        }))
);
