BEM.DOM.decl('b-banner-preview', {
    onSetMod: {
        js: function() {
            var alert = this.findBlockInside('adv-alert', 'b-banner-adv-alert'),
                geo = this.findBlockInside('geo-names', 'b-group-regions');

            if (alert && geo) {
                alert
                    .on('warning-added', function() {
                        geo.setMod('warning', 'hidden');
                    });
            }

            this.params.modelParams && this.setBanner(this.params.modelParams);

            this._vcardPopupOpener = this.findBlockOn('vcard', 'b-modal-popup-opener');

            this
                .bindTo('title', 'click', this._onTitleClick)
                .bindTo('stop-and-remoderate', 'click', this._onStopAndRemoderateClick);

            this._vcardPopupOpener && !this._vcardPopupOpener.getUrl() &&
                this.bindTo('vcard', 'click', this._onVCardClick);

            this.bindTo('addition-link', 'click', function(event) {
                var type = this.findBlockOn(event.data.domElem, 'link').params.type;

                this._getPopup()
                    .setContent(this._getPopupContent(type))
                    .toggle(this.elemInstance('addition-link', 'type', type));
            });
        }
    },

    /**
     * Связываем превью с конкретной моделью баннера
     * @param {Object} modelParams
     */
    setBanner: function(modelParams) {
        this.model = BEM.MODEL.getOrCreate(modelParams);

        if (modelParams.parentName) {
            this.groupModel = BEM.MODEL.getOrCreate({
                id: modelParams.parentId,
                name: modelParams.parentName
            });
        }

        this._bindToBanner();
    },

    _bindToBanner: function() {
        //implemented in subclasses
    },

    /**
     *
     * Запрашиваем инстанс попапа
     * @returns {BEM}
     * @private
     */
    _getPopup: function() {
        return this._popup || (this._popup = BEM.blocks['b-shared-popup'].getInstance({
            animate: 'yes',
            'has-close': 'yes'
        }, { directions: ['right-middle-middle', 'top-left-right', 'bottom-left-right'] }));
    },

    /**
     * Строим bemhtml для попапа
     * @param {'image'|'sitelink'} type
     * @returns {BEM}
     * @private
     */
    _getPopupContent: function(type) {
        var params = this.elemInstance('additions').params,
            banner = params.banner,
            randPhrase,
            customBody,
            customTitle;

        if (this.groupModel) {
            var phraseModel = this.groupModel.getRandomActivePhraseModel();
            if (phraseModel) {
                randPhrase = phraseModel.toJSON();
            }
        } else {
            randPhrase = u['dm-base-group'].getRandomActivePhrase(banner.phrases);
        }

        if (banner.isTemplateBanner) {
            // для баннеров с шаблоном надо передавать customTitle и customBody,
            // потому как они уже могут содержать html
            customBody = banner.body;
            customTitle = banner.title;
        }

        return BEMHTML.apply({
            block: 'b-banner-preview',
            modelParams: this.params.modelParams,
            statusOpenStat: this.params.statusOpenStat,
            statusClickTrack: this.params.statusClickTrack,
            banner: this.model ? this.model.provideData() : banner,
            customTitle: customTitle,
            customBody: customBody,
            randPhrase: randPhrase,
            hideAdWarnings: true,
            hideTemplateWarning: true,
            hideWarnings: true,
            hideAdditions: true,
            showThumbnail: type == 'image',
            hideSitelinks: type == 'image',
            mods: { type: type }
        });
    },

    _formatUrl: function(url) {
        if (!url) return '';

        var statusOpenStat = this.model.get('statusOpenStat') || this.params.statusOpenStat,
            statusClickTrack = this.model.get('status_click_track') || this.params.statusClickTrack;

        if (!/^(http|https)/.test(url))
            url = 'https://' + url;

        return u.getPreviewUrl(url, u.getPreviewUrlParams(
            this.randPhrase && this.randPhrase.toJSON(),
            statusOpenStat === 'Yes',
            statusClickTrack));
    },

    _onAddLinkClick: function(e) {
        var modValue = this.getMod(e.data.domElem, 'for');

        switch (modValue) {
            case 'image':
            case 'sitelinks':
                this.findBlockOn(this.elem('popup', 'for', modValue), 'b-popupa').show(e.data.domElem);
                break;
        }
    },

    /**
     * Строим урл для картинки в превью
     * @param {String} hash
     * @returns {String}
     * @private
     */
    _makeThumbURL: function(hash) {
        return hash === '' ?
            '/block/b-banner-preview/b-banner-preview__image_type_default.png' :
            u.getImageUrl({ hash: hash, size: 'x90' });
    },

    _setThumb: function(src) {
        this.elem('image')
            .css({
                display: 'inline',
                position: 'static',  // важно сбросить: динамическая превьюшка работает с position!
                width: '',
                height: ''
            })
            .attr('src', this._makeThumbURL(src));

        return this;
    },

    /**
     * Правила для обработки события click по заголовку баннера
     * @returns {Boolean}
     * @private
     */
    _onTitleClickValidate: function() {
        return !this.elem('domain').length || (this.model && !this.model.get('has_href'));
    },

    /**
     * Обработчик события click по заголовку баннера
     * @param {Event} e
     */
    _onTitleClick: function(e) {
        var linkElem = e.data.domElem;

        // для события в p-view-vcard-headless (не стоит закрывать окно при клике на пустую ссылку (DIRECT-41700))
        linkElem.attr('href') && this.trigger('title-click');

        if (this._onTitleClickValidate()) {
            e.preventDefault();
            this._showVCard();
        }
    },

    /**
     * Обработка клика по ссылке "Адрес и телефон"
     * @param {Object} e
     * @returns {Boolean}
     */
    _onVCardClick: function(e) {
        e.preventDefault();

        this._showVCard();

        return false;
    },

    /**
     *
     * @param {Object} e
     * @private
     */
    _onStopAndRemoderateClick: function(e) {
        e.preventDefault();

        BEM.blocks['b-confirm'].open({
            message: iget2(
                'b-banner-preview',
                'vy-uvereny-chto-hotite',
                'Вы уверены, что хотите ОСТАНОВИТЬ показы и отправить объявление на ПЕРЕМОДЕРАЦИЮ?'
            ),
            onYes: function() {

                var params = this.params,
                    bid = this.model.get('bid');

                /* jshint ignore:start */
                window
                    .open(
                        u.getUrl('stopAndRemoderateBanner', {
                            bid: bid,
                            bids: bid,
                            cid: this.model.get('cid'),
                            csrf_token: u.consts('csrf_token')
                        }),
                        '_blank')
                    .focus();
                /* jshint ignore:end */
            }
        }, this);
    },

    addAdminStatus: function(type, text) {
        if (this.findElem('admin-status', 'type', type).length) return;

        this.elem('statuses').append(BEMHTML.apply({
            block: 'b-banner-preview',
            elem: 'admin-status',
            mix: [{ block: 'b-banner-preview', elem: 'status' }],
            mods: { type: type },
            // cyn@TODO: В DIRECT-53578 оторвать disable-next-line и починить
            // eslint-disable-next-line no-undef
            content: text || ADMIN_STATUSES[type]
        }));
    },

    /**
     * Открываем попап с визиткой
     */
    _showVCard: function() {
        if (!this.model || !this.model.get('has_vcard')) return;

        this._vcardPopupOpener && this._vcardPopupOpener.show(this._buildVCardUrl());
    },

    /**
     * Возвращает url страницы с контактной информацией или объект с параметрами для HTTP запроса, необходимыми
     * для получения страницы контактной информации
     *
     * @returns {String|Object}
     * @private
     */
    _buildVCardUrl: function() {
        var model = this.model,
            vcardData;

        if (!this.model) return;

        if (this.model.get('loadVCardFromClient')) {
            vcardData = this.__self.getVCardData(model);
            // параметры POST запроса для построения страницы визитки по данным о визитке из модели баннера
            return {
                action: u.getUrl(),
                method: 'POST',
                data: Object.keys(vcardData || {}).map(function(name) {
                    return {
                        name: name,
                        // экранирование с безопасным эвалом (чтобы не заменять кавычки и html сущности, не относящиеся к разметке)
                        value: $('<div>').html(u.escapeHTML(vcardData[name] || '')).html()
                    };
                })
            };
        }

        var urlParams = this.params.publicIdentity ?
            { public_identity: this.params.publicIdentity } :
        {
            bid: this.model.get('bid'),
                //когда на всех страницах, где используются превью начнут приходить группы
                //останется this.groupModel.get('cid')
            cid: this.model.get('cid') || this.groupModel && this.groupModel.get('cid')
        };

        return u.getUrl('showContactInfo', urlParams);
    },

    /**
     * Уничтожение инстанса баннера (в том числе из DOM)
     */
    destruct: function() {
        this.model && this.model.un();
        //триггерим событие для внешних блоков (например, b-group-preview)
        this.trigger('destruct', { id: this.params.modelId, fromPreview: true });

        this.__base.apply(this, arguments);
    }
}, {
    /**
     * Возвращает хэш с данными о визитке
     * @param {BEM.MODEL} model модель баннера
     * @returns {Object}
     */
    getVCardData: function(model) {
        var data = {
                cmd: 'showContactInfo',
                from: 'edit',
                bid: model.get('bid') || 0,
                cid: model.get('cid')
            },
            vcardData = model.getVCardData();

        return $.extend(data, u._.pick(model.toJSON(), ['title', 'body']), model.get('href_model').toJSON(), vcardData);
    }
});
