// бывший b-banner-preview_with-warnings_yes.js
BEM.DOM.decl({ block: 'b-banner-preview2-warnings', modName: 'auto-check', modVal: 'yes' }, {

    onSetMod: {

        js: function() {
            var bannerModel = this._getModelBanner(),
                hrefModel = bannerModel && bannerModel.get('href_model');

            bannerModel && bannerModel
                .on('geo-check-error', this._onGeoCheckError, this)
                .on('url-check-error', this._onUrlCheckError, this)
                .on('currency-check-error', this._onCurrencyError, this);

            hrefModel && hrefModel.on('url-check-error', this._onUrlCheckError, this);

            //слушает b-banner-href, если он есть
            // и b-edit-banner2_type_mobile-content
            bannerModel.trigger('warnings-blocks-inited');
        }

    },

    /**
     * Обработчик ошибки про ограничения по паре текст/регионы
     * @param {jQuery.Event} e
     * @param {Object} data
     * @param {String[]} data.messages сообщения
     * @private
     */
    _onGeoCheckError: function(e, data) {
        this._textWarning = data.messages;
        this._showWarnings();
    },

    /**
     * Обработчик ошибки про неподдерживаемую валюту
     * @param {jQuery.Event} e
     * @param {Object} data
     * @param {String[]} data.messages сообщения
     * @private
     */
    _onCurrencyError: function(e, data) {
        this._currencyWarnings = data.messages;
        this._showWarnings();
    },

    /**
     * Обработчик ошибки проверки url
     * @param {jQuery.Event} e
     * @param {Object} data
     * @param {String[]} data.messages сообщения
     * @private
     */
    _onUrlCheckError: function(e, data) {
        this._hrefWarnings = data.messages;
        this._showWarnings();
    },

    /**
     * Возвращает модель баннера
     * @returns {BEM.MODEL}
     * @private
     */
    _getModelBanner: function() {
        return this._modelBanner || (this._modelBanner = BEM.MODEL.getOrCreate(this.params.modelParams));
    },

    _warningTexts: null,

    /**
     * Возвращает объект с предупреждениями
     * @returns {Object}
     */
    warningTexts: function() {
        return this._warningTexts || (this._warningTexts = this.__self.warningTexts());
    },

    _getWarnings: function() {
        return [].concat(this._textWarning, this._hrefWarnings, this._currencyWarnings);
    },

    /**
     * Вывести предупреждения
     * @private
     */
    _showWarnings: function() {
        var bemjson = this._getWarnings()
            .filter(function(name) { return !!name; })
            .map(function(name) {
                var error,
                    warnName;

                if ($.isArray(name)) {
                    error = name;
                } else if (typeof name === 'string') {
                    error = this.warningTexts()[name] || u.escapeHTML(name);
                    warnName = name;
                }

                return {
                    block: 'b-banner-preview2-warnings',
                    elem: 'item',
                    content: error,
                    warnName: warnName
                };
            }, this);

        BEM.DOM.update(this.elem('dynamic'), BEMHTML.apply(bemjson));
    },

    destruct: function() {
        var bannerModel = this._getModelBanner(),
            hrefModel = bannerModel && bannerModel.get('href_model');

        bannerModel && bannerModel
            .un('geo-check-error', this._onGeoCheckError, this)
            .un('url-check-error', this._onUrlCheckError, this)
            .un('currency-check-error', this._onCurrencyError, this);

        hrefModel && hrefModel.un('url-check-error', this._onUrlCheckError, this);

        this.__base.apply(this, arguments);
    }

}, {

    //переводы подключаются внизу страницы, так что warningTexts должно быть уже после декларации
    warningTexts: function() {
        return {
            hrefChanged: iget2(
                'b-banner-preview2-warnings',
                'otobrazhaemaya-ssylka-izmenilas-proverte',
                'Отображаемая ссылка изменилась. Проверьте правильность.'
            ),
            hrefDomain: iget2('b-banner-preview2-warnings', 'ssylka-s-zagolovka-vedyot', 'Ссылка с заголовка ведёт на другой домен'),
            hrefParams: iget2(
                'b-banner-preview2-warnings',
                'ssylka-na-sayt-soderzhit',
                'Ссылка на сайт содержит параметры. Кириллические символы при подстановке в URL будут кодированы в utf-8. Убедитесь, что ваш сайт поддерживает эту кодировку.'
            ),
            hrefFormat: iget2('b-banner-preview2-warnings', 'nepravilnyy-format-ssylki', 'Неправильный формат ссылки'),
            hrefLength: iget2(
                'b-banner-preview2-warnings',
                'pri-pokaze-na-poiske',
                'При показе на поиске Яндекса домен может быть отображен в сокращенном виде (только 35 символов)'
            ),
            hrefTooLong: iget2('b-banner-preview2-warnings', 'maksimalnaya-dlina-s-ssylki', 'Максимальная длина ({foo}) ссылки превышена.', {
                foo: u.consts('MAX_URL_LENGTH')
            }),
            trackingHrefTemplate: iget2(
                'b-banner-preview2-warnings',
                'v-trekingovoy-ssylke-shablony',
                'В трекинговой ссылке шаблоны не обрабатываются, символы (##) будут проигнорированы.'
            ),
            notApprovedTrackedSystem: iget2(
                'b-banner-preview2-warnings',
                'dannyy-domen-trekingovoy-sistemy',
                'Данный домен трекинговой системы не поддерживается. {link}.',
                {
                    link: function(text) {
                        return {
                            block: 'b-help-link',
                            mods: { type: 'modal', margin: 'no' },
                            stretched: true,
                            url: u.getHelpUrl('mobile-apps-tracking-url'),
                            text: text
                        };
                    }(iget2('b-banner-preview2-warnings', 'dannyy-domen-trekingovoy-sistemy-param-link', 'Разрешенные трекинговые системы')),

                    context: 'link - Разрешенные трекинговые системы'
                }
            )
        };
    }
});
