block('b-banner-preview2').elem('additions')(
    def()(function() {
        var additions = [
            {
                field: 'showRating',
                title: iget2('b-banner-preview2', 'reyting', 'рейтинг')
            },
            {
                field: 'showRatingVotes',
                title: iget2('b-banner-preview2', 'kolichestvo-ocenok', 'количество оценок')
            },
            {
                field: 'showPrice',
                title: iget2('b-banner-preview2', 'cena', 'цена')
            },
            {
                field: 'showIcon',
                title: iget2('b-banner-preview2', 'ikonka', 'иконка')
            },
            {
                field: 'image',
                title: {
                    block: 'b-banner-preview2',
                    elem: 'image-type-label'
                }
            },
            {
                field: 'sitelinks',
                title: (this.ctxData['sitelinks'] || []).some(function(link) { return !!link.description; }) ?
                    iget2('b-banner-preview2', 'bystrye-ssylki-s-opisaniyami', 'быстрые ссылки с описаниями') :
                    iget2('b-banner-preview2', 'bystrye-ssylki', 'быстрые ссылки')
            },
            {
                field: 'callouts',
                title: iget2('b-banner-preview2', 'utochneniya', 'уточнения')
            },
            {
                field: 'videoExtension',
                title: iget2('b-banner-preview2', 'video', 'видео')
            }
        ]
            .filter(function(opt) {
                if (!opt) return false;

                if (u._.isArray(this.ctxData[opt.field])) return !u._.isEmpty(this.ctxData[opt.field]);

                return !!this.ctxData[opt.field];
            }, this)
            .map(function(opt) {
                return opt.title;
            });

        return additions && additions.length ? applyNext({ 'ctx.additions': additions }) : '';
    }),

    content()(function() {
        return [
            {
                block: 'link',
                mods: {
                    pseudo: 'yes',
                    theme: 'without-border'
                },
                mix: [{
                    block: 'b-banner-preview2',
                    elem: 'additions-link'
                }],
                content: iget2('b-banner-preview2', 'dopolneniya-100', 'Дополнения') + ':'
            },
            {
                elem: 'additions-sub-text',
                content: u.spacer2(this.ctx.additions, ', ')
            }
        ];
    })
);
