block('b-banner-preview2')
    .elem('html5-preview')(
        match(function() {
            var ctx = this.ctxData;

            return !(ctx.creative && ctx.creative.creative_id);
        }).def()(''),

        content()(function() {
            var ctx = this.ctxData,
                isFromImage = ctx.creative.composed_from !== 'image',
                isCpmGeoproduct = ctx.cpmBannersType === 'cpm_geoproduct',
                // у Баннера в метро есть оригинальный размер баннера 640х100,
                // который не нужно считать баннером для ретины и уменьшать его размер в 2 раза.
                imageData = isCpmGeoproduct ? ctx.creative : u.imageAd.fixDimensions(ctx.creative),
                sharedData = {};

            if (ctx.adType === 'cpm_yndx_frontpage') {
                sharedData.productType = 'CPM_YNDX_FRONTPAGE';
            }

            var hasTurbolanding = u._.get(this.ctxData, 'turbolanding.id', '0') !== '0',
                turbolandingLink = hasTurbolanding ? u._.get(this.ctxData, 'turbolanding.href') : '';

            return [
                {
                    block: 'creative-preview-opener',
                    preview: imageData,
                    popupContent: {
                        block: 'creative-preview',
                        source: imageData.live_preview_url + '?pcodever=' + u['auto-pcode'].getVersion() + '&shared_data=' + encodeURIComponent(JSON.stringify(sharedData)),
                        creative: imageData,
                        postData: {
                            type: 'html5-preview',
                            data: {
                                click_url: {
                                    clickUrl1: turbolandingLink || ctx.customTitleUrl || ctx.url
                                }
                            }
                        }
                    }
                },
                {
                    block: 'b-banner-preview2',
                    elem: 'image-preview-label',
                    mix: { elem: 'image-type-label' },  // добавляет css, появилось по DIRECT-59334
                    content: (
                        isFromImage ?
                            iget2('b-banner-preview2', 'html5-banner', 'HTML5 баннер') :
                            iget2('b-banner-preview2', 'banner-image', 'Баннер-изображение') // картинка из html5 креатива называется так
                        ) + ': ' + imageData.width + 'x' + imageData.height

                },
                {
                    elem: 'turbo-landings'
                }
            ];
        })
    );
