block('b-banner-preview2')
    .elem('image-preview')(
        match(function() {
            var ctx = this.ctxData;

            return !(ctx.imageAd && ctx.imageAd.hash) && !(ctx.creative && ctx.creative.creative_id);
        }).def()(''),

        content()(function() {
            var ctx = this.ctxData,
                isCreative = ctx.creative && ctx.creative.creative_id != '',
                contentData = isCreative ? ctx.creative : ctx.imageAd,
                isCpmGeoproduct = ctx.cpmBannersType === 'cpm_geoproduct',
                // у Баннера в метро есть оригинальный размер баннера 640х100,
                // который не нужно считать баннером для ретины и уменьшать его размер в 2 раза.
                imageData = isCpmGeoproduct ? ctx.creative : u.imageAd.fixDimensions(contentData),
                labelDuration,
                labelPreview = iget2('b-banner-preview2', 'kreativ', 'Креатив') + ': ' + imageData.width + 'x' + imageData.height;

            if (contentData.creative_type === 'video_addition') {
                labelPreview = iget2('b-banner-preview2', 'video-kreativ', 'Видеокреатив');
                labelDuration = iget2('b-banner-preview2', 'video-duration', '{duration} сек', {
                    duration: contentData.duration
                });

                if (contentData.cpmSubtype === 'cpm_video' && contentData.has_packshot) {
                    labelPreview = [
                        {
                            block: 'icon',
                            mods: { type: 'packshot' },
                            mix: {
                                block: this.block,
                                elem: 'packshot-icon'
                            }
                        },
                        iget2('b-banner-preview2', 'cpm-video-creative-with-packshot', 'Видеокреатив с пэкшотом')
                    ];
                } else if (contentData.cpmSubtype === 'cpm_audio') {
                    labelPreview = iget2('b-banner-preview2', 'audio-creative', 'Аудиокреатив') + ': ' + labelDuration;
                } else if ((contentData.outdoorResolutions || []).length) {
                    labelPreview = [
                        labelPreview + ': ' + labelDuration,
                        contentData.outdoorResolutions.join('px, ') + 'px'
                    ].join(', ');
                }
            }

            if (contentData.is_adaptive === '1') {
                labelPreview = iget2('b-banner-preview2', 'adaptive', 'Адаптивный креатив');
            }

            var siteLink = this.ctxData.customTitleUrl || this.ctxData.url,
                hasTurbolanding = u._.get(this.ctxData, 'turbolanding.id', '0') !== '0',
                turbolandingLink = hasTurbolanding ? u._.get(this.ctxData, 'turbolanding.href') : '',
                clickUrl = siteLink || turbolandingLink,
                imagePreviewBlock = {
                    block: 'image-preview',
                    mods: { type: 'scale' },
                    videoPreview: contentData.live_preview_url,
                    banner: u['b-banner-preview2'].getVideoPreviewPostMessage(this.ctxData),
                    scale: imageData.scale,
                    width: imageData.width,
                    height: imageData.height,
                    clickUrl: clickUrl,
                    imageUrl: isCreative ?
                        imageData.preview_url :
                        u.getImageUrl({
                            namespace: 'direct-picture',
                            mdsGroupId: imageData.group_id,
                            hash: imageData.hash
                        })
                }

            return [
                clickUrl ? {
                    block: 'link',
                    mix: {
                        block: 'b-banner-preview2',
                        elem: 'preview-image-link'
                    },
                    url: clickUrl,
                    target: '_blank',
                    content: imagePreviewBlock
                } : imagePreviewBlock,
                {
                    block: 'b-banner-preview2',
                    elem: 'image-preview-label',
                    mix: { elem: 'image-type-label' },  // добавляет css, появилось по DIRECT-59334
                    content: labelPreview
                },
                {
                    elem: 'turbo-landings'
                }
            ];
        })
    );
