block('b-banner-preview2').elem('image')(

    match(function() {
        return !(this.ctxData.image || this.ctxData.creative || this.ctxData.imageAd);
    }).def()(''),

    tag()('img'),

    attrs()(function() {
        var ctxData = this.ctxData,
            alt = ctxData.title || '',
            src = ctxData.image === true ?
            '/data3/desktop.blocks/b-banner-preview2/__image/b-banner-preview2__image.png' :
            u.getImageUrl({ mdsGroupId: ctxData.mdsGroupId, hash: ctxData.image, size: 'x90' });

        return {
            src: src,
            alt: alt,
            title: alt
        };
    }),

    elemMod('type', 'performance').attrs()(function() {
        var creative = this.ctxData.creative,
            previewScale = creative.preview_scale || 1;

        return {
            src: creative.preview_url,
            width: creative.width != 0 ? creative.width * previewScale : undefined,
            height: creative.height != 0 ? creative.height * previewScale : undefined,
            alt: creative.alt_text || '',
            title: creative.name
        };
    }),

    elemMod('type', 'text-image').attrs()(function() {
        var ctx = this.ctxData,
            isCreative = ctx.creative && ctx.creative.creative_id != '',
            contentData = isCreative ? ctx.creative : ctx.imageAd,
            isAdaptiveHeight = ctx.isAdaptiveHeight,
            imageData = u.imageAd.fixDimensions(contentData),
            scale = imageData.scale,
            imageUrl = isCreative ?
                imageData.preview_url :
                u.getImageUrl({ namespace: 'direct-picture', mdsGroupId: imageData.group_id, hash: imageData.hash });

        return {
            src: imageUrl,
            width: imageData.width * scale,
            height: isAdaptiveHeight ? undefined : imageData.height * scale,
            alt: ''
        };
    })
);
