BEM.DOM.decl({ block: 'b-banner-preview2', elem: 'partner-code' }, {

    onSetMod: {
        js: function() {
            this.renderBlock();
        }
    },

    /**
     * Отрисовка элемента
     */
    renderBlock: function() {
        var parent = this._getParent(),
            dna = window.dna,
            bannerPreviewData = u['b-banner-preview2'].getDataToDNAPreview(parent);

        dna.reactDOMRender(dna.reactCreateElement(
            dna.components.BannerSimplePreview, bannerPreviewData, null), this.domElem[0]);
    },

    /**
     * Возвращает инстанс родительского блока
     * @return {BEM}
     * @private
     */
    _getParent: function() {
        return this._parent || (this._parent = this.getParent())
    },

    /**
     * Обработчик нажатия на ссылку
     * https://github.yandex-team.ru/any/concept/tree/develop/examples/docs#complex-example-direct-banner
     * @param {String} linkType
     * @private
     */
    _onLinkClick: function(linkType) {
        var ctxData = this._getParent().getCtxData();

        if (ctxData.vcard && linkType == 'address' || !ctxData.url && linkType == 'title') {
            this._tryToOpenVCard();
        }
    },

    /**
     * Обработчик события: баннер обновлен
     * @param {String} id - идентификатор баннера
     * @param {Object} banner - размеры баннера
     * @param {Number} banner.height - высота
     * @private
     */
    _onUpdate: function(id, banner) {
        this._updateFrameHeight(banner.height);
    },

    /**
     * Обработчик события: баннер отрисован
     * @param {String} id - идентификатор баннера
     * @param {Object} banner - размеры баннера
     * @param {Number} banner.height - высота
     * @private
     */
    _onRender: function(id, banner) {
        this._updateFrameHeight(banner.height);
        this.delMod('loading');
    },

    /**
     * Выставляет высоту фрейму
     * @param {Number} height - высота фрейма
     * @private
     */
    _updateFrameHeight: function(height) {
        height !== 0 && (this._frame.iFrame.height = height);
    },

    /**
     * Проверяет наличие визитки, и пытается её открыть методом основного блока
     * @param {Event} e
     * @private
     */
    _tryToOpenVCard: function(e) {
        this._getParent().getCtxData().vcard && this._getParent().openVcard();
    },

    /**
     * Обновляет баннер внутри iframe
     */
    update: function() {
        var parent = this._getParent(),
            options = this._prepareFrameParams(
                this.domElem.attr('id'),
                u['b-banner-preview2'].getDataToPcode(parent)
            );

        if (this._frame) {
            this._frame.update(options.params);
        }
    },

    /**
     * @typedef {Object} FrameApiData - параметры для FrameAPI
     * @desc Подробности в задаче PCODE-4054
     *
     * @property {String} element - id DOM элемента, куда будет вставлен iframe
     * @property {String} type - тип баннера ( https://static.yandex.net/partner-code/loaders/banner_formats.json )
     * @property {Number} pcodever - версия партнерского кода
     * @property {Object} [callbacks] - функции вызываемые библиотекой
     * @property {Object} [params] - параметры отображения
     * @property {Object} [params.data] - данные баннера
     * @property {Object} [params.data.direct] - данные баннера директа
     * @property {DataToPcode.ads} [params.data.direct.ads] - массив баннеров
     * @property {Object} [params.data.common]
     */

    /**
     * Преобразует данные в входные параметры библиотеки Frame API
     * @param {String} elementId - id DOM элемента, куда будет вставлен iframe
     * @param {DataToPcode} data - подготовленные данные баннера
     * @return {FrameApiData}
     * @private
     */
    _prepareFrameParams: function(elementId, data) {
        var frameData = {
            element: elementId,
            type: data.type,
            pcodever: u['auto-pcode'].getVersion(),
            callbacks: {
                onLinkClick: this._onLinkClick.bind(this),
                onRender: this._onRender.bind(this),
                onUpdate: this._onUpdate.bind(this)
            },
            params: {
                // тут опциональные параметры стилизации, перечень искать тут:
                // https://github.yandex-team.ru/any/concept/tree/develop/examples/docs, описания нет
                border_radius: false,
                callouts: true,
                header_bg_color: 'FFFFFF',
                font_size: '0.8',
                ad_format: 'direct',
                data: {
                    direct: {
                        ads: data.ads,
                        directTitle: {
                            title: '',
                            url: ''
                        }
                    },
                    common: {
                        linkHead: '',
                        domains: [],
                        isYandex: '1',
                        isYandexPage: '0',
                        isSearchPage: '0',
                        showAdTune: '',
                        stripeType: '1',
                        stripeAnimation: '0',
                        reloadTimeout: '15'
                    }
                }
            }
        };

        // Если не задать размеры, то pcode построит iframe 1000x600
        // Ограничания по ширине есть в css (тут дублируются)
        // Ограничения по высоте подбирались ручками, чтобы заполненный баннер влез
        if (data.type === u.pcode.getDefaultViewType()) {
            frameData.params.height = 175;
            frameData.params.width = 360;
        } else { // для РМП
            frameData.params.width = 240;
            frameData.params.height = 400;
        }

        return frameData;
    },

    /**
     * Проверяет наличие изображения в баннере
     * @param {DataToPcode} data - подготовленные данные баннера
     * @return {Boolean}
     * @private
     */
    _hasImage: function(data) {
        return !!u._.get(data, 'ads[0].images')
    },

    /**
     * Рисует превью
     * @param {String} elementId id элемента в котором нужно отрисовать превью
     * @param {Object} data данные для отрисовки превью
     * @static
     */
    _show: function(elementId, data) {
        var frameData = this._prepareFrameParams(elementId, data);
        this._frame = new window.Ya.mediaCode.FrameAPI(
            frameData
        );
    }

}, {

    _scriptIsReady: null,

    _scriptIsAdded: null,

    _onLoaded: function() {
        this._scriptIsReady = true;

        this._callbacks.forEach(function(callback) {
            callback();
        });

        this._callbacks = null;
    },

    /**
     * Добавляет скрипт партнерского кода на страницу
     * @static
     * @private
     */
    _addYaContextScript: function() {
        // по загрузке выполнит все колбеки в this._callbacks
        // Объявлять обязательно перед скриптом. Иначе скрипт выполнится в синхронном режиме
        // и выполнит document.write()
        var frameApi = BEM.blocks['i-pcode-script__frame-api'].getOrCreate();

        if (!frameApi.isLoaded()) {
            frameApi.on('loaded', this._onLoaded, this);
        } else {
            this._onLoaded();
        }

        this._scriptIsAdded = true;
    },

    _callbacks: [],

    /**
     * Вызывает отрисовку превью или добавляет в список колбеков, если скрипт еще не загружен
     * @param {String} elementId id элемента в котором нужно отрисовать превью
     * @param {Object} data данные для отрисовки превью
     * @param {Function} callback
     * @static
     */
    render: function(elementId, data, callback) {
        this._scriptIsAdded || this._addYaContextScript();

        if (this._scriptIsReady) {
            callback(elementId, data);
        } else {
            this._callbacks.push(callback.bind(this, elementId, data));
        }
    }

});
