block('b-banner-preview2').elem('title').content()(
    match(function() {
        return true;
    })(function() {
        var hasSiteLink = Boolean(this.ctxData.customTitleUrl || this.ctxData.url),
            siteLink = hasSiteLink ? (this.ctxData.customTitleUrl || this.ctxData.url) : '',
            hasTurbolanding = u._.get(this.ctxData, 'turbolanding.id', '0') !== '0',
            turbolandingLink = hasTurbolanding ? u._.get(this.ctxData, 'turbolanding.href') : '',
            hasOrganization = Boolean(this.ctxData.organization && this.ctxData.organization.profileUrl),
            organizationLink = hasOrganization ? this.ctxData.organization && this.ctxData.organization.profileUrl : '',
            url = this.isSearchMobile ?
                turbolandingLink || siteLink || organizationLink :
                siteLink || turbolandingLink || organizationLink;

        return {
            block: 'link',
            mix: [{
                block: 'b-banner-preview2',
                elem: 'title-link'
            }],
            url: url,
            target: '_blank',
            content: this.ctx.content || u.replaceTemplate(
                this.ctxData.title,
                u['b-banner-preview2'].calcTitleTemplateLimit(this.ctxData.title),
                this.ctxData.phrase,
                'b-banner-preview2__template')
        };
    }),

    // Если урл не указан - ссылка должна открывать попап с визиткой (если она есть)
    match(function() {
        var hasSite = Boolean(this.ctxData.url || this.ctxData.customTitleUrl),
            hasTurbolanding = u._.get(this.ctxData, 'turbolanding.id', '0') !== '0',
            hasOrganization = Boolean(this.ctxData.organization && this.ctxData.organization.profileUrl);

        return !hasSite && !hasTurbolanding && !hasOrganization;
    }).match(function() {
        return this.ctxData.vcard;
    })(function() {
        return u._.extend(applyNext(), {
            mods: {
                pseudo: 'yes',
                theme: 'without-border'
            },
            mix: [{
                block: 'b-banner-preview2',
                elem: 'title-to-vcard'
            }]
        });
    }),

    // Заголовок 2
    match(function() {
        return this.showTitleExtension;
    })(function() {
        var title = u.replaceTemplate(
                this.ctxData.title,
                u['b-banner-preview2'].calcTitleTemplateLimit(this.ctxData.title),
                this.ctxData.phrase,
                null
            ),
            titleExt = u.replaceTemplate(
                this.ctxData.titleExt,
                u['b-banner-preview2'].calcTitleExtTemplateLimit(this.ctxData.titleExt),
                this.ctxData.phrase,
                null
            ),
            // titleEndsWithUnicodeChar для проверки Unicode символов (например, " - &#34;)
            titleEndsWithUnicodeChar = /&#(\d+|[a-zA-Z]);$/,
            separator = /[\!\?,\.\:;]$/.test(title) && !titleEndsWithUnicodeChar.test(title) ? ' ' : '. ',
            titleExtWithFirstUpperLetter = (titleExt[0] || '').toUpperCase() + titleExt.slice(1),
            fullTitle = [title, titleExtWithFirstUpperLetter].join(separator);

        return u._.extend(applyNext(), {
            content: fullTitle
        });
    })
);
