BEM.MODEL.decl({ model: 'b-banner-preview2_type_content-promotion', baseModel: 'b-banner-preview2' }, {
    // Идентификатор кампании
    cid: { type: 'string' },

    // Идентификатор баннера
    bid: { type: 'string' },

    // Ссылка на thumbnail видеоролика
    video_preview_image_href: { type: 'string' },

    // Ссылка на thumbnail Яндекс.Коллекции
    collection_preview_image_href: { type: 'string' },

    title: { type: 'string' },

    description: { type: 'string' },

    content_promotion_content_type: { type: 'string' },

    // Объект с регионами
    geo: { type: 'object' },

    // кликовая ссылка (ссылка в пэкшоте)
    url: { type: 'string' }
}, {

    /**
     * Заполняет данными и инициализирует view-модель
     * @param {Object} ids Идентификаторы data-моделей
     * @param {String} ids.bannerId Идентификатор модели баннер
     * @param {String} ids.groupId Идентификатор модели группы
     */
    init: function(ids) {
        this.set('_dmDecl', {
            banner: {
                name: 'dm-content-promotion-banner',
                id: ids.bannerId,
                parentName: 'dm-content-promotion-group',
                parentId: ids.groupId
            },
            group: {
                name: 'dm-content-promotion-group',
                id: ids.groupId
            }
        });

        this.__base();
    },

    /**
     * Подготавливает данные для view-модели из объекта с data-моделями
     * @param {Object} dataModels объект с data-моделями
     * @param {String[]} required список полей, которые нужно получить. Если не передавать, то возвращает объект
     * со всеми полями
     * @returns {{}}
     */
    prepareDataFromDM: function(dataModels, required) {
        var result = {},

            modelBanner = dataModels.banner,
            modelGroup = dataModels.group,

            modelGeo = modelGroup.getGeoModel(),

            modelHref = modelBanner.get('href_model'),

            modelCampaign = modelGroup.getCampaignModel(),

            // для получения только нужных полей (required)
            isNeed = this.getIsNeedFunction(required);

        isNeed('cid') && (result.cid = modelCampaign.get('cid'));

        isNeed('bid') && (result.bid = modelBanner.get('bid'));

        isNeed('video_preview_image_href') && (result.video_preview_image_href = modelBanner.get('video_preview_image_href'));

        isNeed('collection_preview_image_href') && (result.collection_preview_image_href = modelBanner.get('collection_preview_image_href'));

        isNeed('title') && (result.title = modelBanner.get('title'));

        modelGeo && (result.geo = u['b-banner-preview2'].processGeo(modelGeo.get('geo'), modelGeo.get('geoText')));

        isNeed('description') && (result.description = modelBanner.get('description'));

        isNeed('content_promotion_content_type') && (result.content_promotion_content_type = modelGroup.get('content_promotion_content_type'));

        isNeed('url') && (result.url = modelHref.get('href') && (modelHref.get('url_protocol') + modelHref.get('href')));

        return result;
    },

    /**
     * Возвращает объект зависимостей полей view-модели от data-моделей
     * @returns {Object}
     * @private
     */
    _dependsFromDMs: function() {
        return {
            banner: {
                collection_preview_image_href: ['collection_preview_image_href'],
                video_preview_image_href: ['video_preview_image_href'],
                description: ['description'],
                title: ['title'],
                content_promotion_content_type: ['content_promotion_content_type'],
                href_model: ['url']
            }
        };
    },
});
