u.register({

    'b-banner-preview2_type_dynamic': {

        /**
         * Преобразует серверные данные баннера в формат блока b-banner-preview2
         * @param {Object} data параметры
         * @param {Object} data.banner Объект баннера
         * @param {Object} data.group Объект группы
         * @param {Object} data.campaign Объект кампании
         * @returns {Object}
         */
        fromServer: function(data) {
            var bannerData = data.banner,
                groupData = data.group,
                campaignData = data.campaign,
                result = {},
                isOpenStat = bannerData.statusOpenStat == 'Yes' || groupData.statusOpenStat == 'Yes' ||
                    campaignData.statusOpenStat == 'Yes',
                isClickTrack = !!(bannerData.status_click_track || campaignData.status_click_track),
                baseBannerPreviewUtils = u['b-banner-preview2'],
                sitelinks = (bannerData.sitelinks || []).filter(function(sitelink) { return sitelink.title }),
                objectHrefParams = u['b-banner-preview2_type_dynamic'].getObjectHrefParams(groupData.href_params),
                // на статистике домен приходит в объект баннера и поле называется adgroup_main_domain
                mainDomain = groupData.main_domain || groupData.adgroup_main_domain;

            result.cid = campaignData.cid;

            result.bid = bannerData.bid || '0'; // 0 при копировании

            result.loadVCardFromClient = bannerData.loadVCardFromClient;

            result.title = u.dynamicGroupsData.getBannerTitle() || '';

            // форматирует описание баннера, эта же функция вызывается в dm-dynamic-banner.js
            result.body = bannerData.body ?
                u.preview.prettifyText(bannerData.body) :
                iget2('b-banner-preview2', 'tekst-vashego-obyavleniya-o', 'Текст вашего объявления о рекламе услуги или товара.');

            bannerData.image && (result.image = bannerData.image);
            bannerData.image_width && (result.imageWidth = +bannerData.image_width);
            bannerData.image_height && (result.imageHeight = +bannerData.image_height);

            bannerData.mds_group_id && (result.mdsGroupId = bannerData.mds_group_id);

            sitelinks.length && (result.sitelinks = sitelinks.map(function(sitelink) {
                return {
                    title: sitelink.title,
                    url: u.formatHref(sitelink.href, isOpenStat),
                    description: sitelink.description || ''
                };
            }));

            result.url = u['b-banner-preview2_type_dynamic'].getDynamicBannerUrl({
                main_domain: mainDomain,
                objectHrefParams: objectHrefParams,
                isOpenStat: isOpenStat,
                isClickTrack: isClickTrack
            });

            result.isHrefHasParams = !u._.isEmpty(objectHrefParams);

            bannerData.callouts && (result.callouts = bannerData.callouts);

            result.domain = mainDomain; // проверка на data_source нужна только при создании,
                                        // поэтому сюда ее не переносим

            result.flags = u['b-banner-preview2'].filterFlagsWithSameParent(bannerData.hash_flags);

            result.flagsSettings = u['b-banner-preview2_type_dynamic'].getFlagsSettings({
                bid: +bannerData.bid,
                isNewGroup: groupData.isNewGroup,
                isCopyGroup: groupData.isCopyGroup
            });

            result.rating = groupData.market_rating || -1;

            groupData.geo && (result.geo = baseBannerPreviewUtils
                .processGeo(groupData.geo, groupData.geo_names, bannerData.geo_exception));

            return u._.extend(baseBannerPreviewUtils.getVCard(bannerData), result);
        },

        /**
         * Возвращает объект с параметрами из строки
         * @param {String} str
         * @return {Object}
         */
        getObjectHrefParams: function(str) {
            // обрезаем все знаки '?' в начале и добавляем 1, чтобы parseUrl воспринял строку как url
            var objectParams = u.parseUrl('?' + (str || '').replace(/^\?*/, '')).query;

            // parseUrl из строки вида '?a=b&&b=c' делает объект `{ a='b', b='c', '': undefined }`,
            // поэтому фильтруем лишнее
            return Object.keys(objectParams).reduce(function(result, key) {
                if (key && objectParams[key]) {
                    result[key] = objectParams[key];
                }

                return result;
            }, {});
        },

        /**
         * Возвращает урл для динамического объявления
         * @param {Object} opts параметры
         * @param {String} opts.main_domain Домен
         * @param {Object} opts.objectHrefParams Параметры в ссылке
         * @param {Boolean} opts.isOpenStat
         * @param {Boolean} opts.isClickTrack
         */
        getDynamicBannerUrl: function(opts) {
            return u.isUrl(opts.main_domain || '') ?
                u.getPreviewUrl(
                    opts.main_domain,
                    u.deepExtend(
                        { add: opts.objectHrefParams },
                        u.getPreviewUrlParams(opts.isOpenStat, opts.isClickTrack))) :
                ''
        },

        /**
         * Метод возвращает набор параметров для предупреждений из модерации, которые будут доступны в базовом виде
         * В других видах обычно возможностей изменения нет
         * @param {Object} obj
         * @param {Number} obj.bid bid баннера
         * @param {Boolean} obj.isNewGroup Флаг новой группы
         * @param {Boolean} obj.isCopyGroup Флаг скопированной группы
         * @returns {Object}
         */
        getFlagsSettings: function(obj) {
            var isBannerNew = obj.isNewGroup || obj.isCopyGroup || !obj.bid;

            // Для динамических объявлений менять предупреждения не умеем DIRECT-46737
            return {
                age: {
                    dontShow: isBannerNew || u.consts('tld') == 'com.tr',
                    edit: false,
                    addRemove: false
                },
                other: {
                    dontShow: isBannerNew,
                    edit: false,
                    addRemove: false
                }
            };
        }

    }

});
