BEM.MODEL.decl({ model: 'b-banner-preview2_type_dynamic', baseModel: 'b-banner-preview2' }, {

    // Идентификатор кампании
    cid: { type: 'string' },

    // Идентификатор баннера
    bid: { type: 'string' },

    // Заголовок баннера
    title: { type: 'string' },

    // Текст баннера
    body: { type: 'string' },

    // Ссылка баннера
    url: { type: 'string' },

    // Рейтинг магазина в маркете (если ссылка ведет на интернет-магазин), иначе '-1'
    rating: { type: 'string' },

    // Домен из ссылки
    domain: { type: 'string' },

    // Хэш картинки объявления
    image: { type: 'string' },

    // Ширина картинки объявления
    imageWidth: { type: 'number' },

    // Высота картинки объявления
    imageHeight: { type: 'number' },

    // Номер группы в Аватарнице
    mdsGroupId: { type: 'string' },

    // Уточнения
    callouts: { type: 'array' },

    // Список быстрых ссылок
    sitelinks: { type: 'array' },

    // Данные для VCard - start
    // Флаг наличия ссылки на визитку
    vcard: { type: 'boolean' },

    // Флаг о необходимости открытия визитки из параметров модели
    loadVCardFromClient: { type: 'boolean' },

    // Страна
    country: { type: 'string' },

    // Город
    city: { type: 'string' },

    // Код города
    city_code: { type: 'string' },

    // Код страны
    country_code: { type: 'string' },

    // Телефон указанный в визитке
    phone: { type: 'string' },

    // Добавочный номер
    ext: { type: 'string' },

    // Название компании/ФИО
    name: { type: 'string' },

    // Контактное лицо
    contactperson: { type: 'string' },

    // Время работы указанное в визитке
    worktime: { type: 'string' },

    // Улица
    street: { type: 'string' },

    // Номер дома
    house: { type: 'string' },

    // Строение
    build: { type: 'string' },

    // Офис
    apart: { type: 'string' },

    // Автоматическая точка на карте
    auto_point: { type: 'string' },

    // Автоматические границы карты
    auto_bounds: { type: 'string' },

    // Автоматическая детализация
    auto_precision: { type: 'string' },

    // Заданная точка на карте
    manual_point: { type: 'string' },

    // Заданные границы карты
    manual_bounds: { type: 'string' },

    // Идентификатор станции метро
    metro: { type: 'string' },

    // Контактный email
    contact_email: { type: 'string' },

    // Тип ИМ
    im_client: { type: 'string' },

    // ИМ Логин
    im_login: { type: 'string' },

    // Подробнее о товаре/услуге
    extra_message: { type: 'string' },

    org_details_id: { type: 'string' },

    // ОГРН/ОГРНИП
    ogrn: { type: 'string' },
    // Данные для VCard - end

    // Объект с предупреждениями из модерации
    flags: {
        type: 'object',
        default: {}
    },

    // Настройки отображения и работы предупреждений из модерации
    flagsSettings: { type: 'object' },

    // Объект с регионами
    geo: { type: 'object' },

    // Флаг о том, что объявление является архивным
    isArchived: { type: 'boolean' },

    // Флаг о наличии параметров в урле
    isHrefHasParams: { type: 'boolean' }

}, {

    /**
     * Заполняет данными и инициализирует view-модель
     * @param {Object} ids Идентификаторы data-моделей
     * @param {String} ids.bannerId Идентификатор модели баннер
     * @param {String} ids.groupId Идентификатор модели группы
     */
    init: function(ids) {
        this.set('_dmDecl', {
            banner: {
                name: 'dm-dynamic-banner',
                id: ids.bannerId,
                parentName: 'dm-dynamic-group',
                parentId: ids.groupId
            },
            group: {
                name: 'dm-dynamic-group',
                id: ids.groupId
            }
        });

        this.__base();
    },

    /**
     * Подготавливает данные для view-модели из объекта с data-моделями
     * @param {Object} dataModels объект с data-моделями
     * @param {String[]} required список полей, которые нужно получить. Если не передавать, то возвращает объект
     * со всеми полями
     * @returns {{}}
     */
    prepareDataFromDM: function(dataModels, required) {
        var result = {},

            modelBanner = dataModels.banner,
            modelGroup = dataModels.group,

            modelGeo = modelGroup.getGeoModel(),
            modelImage = modelBanner.get('image_model'),
            modelCampaign = modelGroup.getCampaignModel(),

            dataVCard = modelBanner.get('vcard').toJSON(),

            objectHrefParams = u['b-banner-preview2_type_dynamic'].getObjectHrefParams(modelGroup.get('href_params')),

            sitelinksModelJson = modelBanner.get('sitelinks') && modelBanner.get('sitelinks').toJSON(),
            vcardIsShow = !!(modelBanner.get('has_vcard') && !modelBanner.get('isVCardEmpty')),

            isOpenStat = modelBanner.get('statusOpenStat') === 'Yes' || modelGroup.get('statusOpenStat') === 'Yes' ||
                modelCampaign.get('statusOpenStat') === 'Yes',
            isClickTrack = modelBanner.get('status_click_track') || !!modelCampaign.get('status_click_track'),

            // для получения только нужных полей (required)
            isNeed = this.getIsNeedFunction(required);

        isNeed('cid') && (result.cid = modelCampaign.get('cid'));

        isNeed('bid') && (result.bid = modelBanner.get('bid'));

        isNeed('url') && (result.url = u['b-banner-preview2_type_dynamic'].getDynamicBannerUrl({
            main_domain: modelGroup.get('main_domain'),
            objectHrefParams: objectHrefParams,
            isOpenStat: isOpenStat,
            isClickTrack: isClickTrack
        }));

        isNeed('title') && (result.title = u.dynamicGroupsData.getBannerTitle() || '');

        isNeed('body') && (result.body = modelBanner.get('body') ||
            iget2('b-banner-preview2', 'tekst-vashego-obyavleniya-o', 'Текст вашего объявления о рекламе услуги или товара.'));

        isNeed('rating') && (result.rating = modelGroup.get('market_rating'));

        if (isNeed('domain')) {
            result.domain = modelGroup.get('data_source') == 'domain' ?
                modelGroup.get('main_domain') :
                '';
        }

        isNeed('isHrefHasParams') && (result.isHrefHasParams = !u._.isEmpty(objectHrefParams));

        isNeed('callouts') && (result.callouts = modelBanner.get('callouts'));

        isNeed('image') && (result.image = modelImage.get('image'));
        isNeed('imageWidth') && (result.imageWidth = modelImage.get('image_width'));
        isNeed('imageHeight') && (result.imageHeight = modelImage.get('image_height'));

        isNeed('mdsGroupId') && (result.mdsGroupId = modelImage.get('mds_group_id'));

        isNeed('sitelinks') &&
            (result.sitelinks = u._.range(u.consts('SITELINKS_NUMBER')).reduce(function(sitelinks, index) {
                var title = sitelinksModelJson['title' + index];

                title && (sitelinks[index] = {
                    title: title,
                    url: u['b-banner-preview2'].formatSitelinkUrl(
                        sitelinksModelJson['href' + index],
                        sitelinksModelJson['url_protocol' + index],
                        isOpenStat),
                    description: sitelinksModelJson['description' + index]
                });

                return sitelinks;
            }, []));

        // Данные визитки необходимые для открытия попапа визитки - start
        isNeed('vcard') && (result.vcard = vcardIsShow);

        isNeed('loadVCardFromClient') && (result.loadVCardFromClient = modelBanner.get('loadVCardFromClient'));

        isNeed('country') && (result.country = dataVCard ? dataVCard.country : '');

        isNeed('city') && (result.city = dataVCard ? dataVCard.city : '');

        isNeed('country_code') && (result.country_code = dataVCard ? dataVCard.country_code : '');

        isNeed('city_code') && (result.city_code = dataVCard ? dataVCard.city_code : '');

        isNeed('phone') && (result.phone = dataVCard ? dataVCard.phone : '');

        isNeed('ext') && (result.ext = dataVCard ? dataVCard.ext : '');

        isNeed('name') && (result.name = dataVCard ? dataVCard.name : '');

        isNeed('contactperson') && (result.contactperson = dataVCard ? dataVCard.contactperson : '');

        isNeed('worktime') && (result.worktime = dataVCard ? dataVCard.worktime : '');

        isNeed('street') && (result.street = dataVCard ? dataVCard.street : '');

        isNeed('house') && (result.house = dataVCard ? dataVCard.house : '');

        isNeed('build') && (result.build = dataVCard ? dataVCard.build : '');

        isNeed('apart') && (result.apart = dataVCard ? dataVCard.apart : '');

        isNeed('auto_point') && (result.auto_point = dataVCard ? dataVCard.auto_point : '');

        isNeed('auto_bounds') && (result.auto_bounds = dataVCard ? dataVCard.auto_bounds : '');

        isNeed('auto_precision') && (result.auto_precision = dataVCard ? dataVCard.auto_precision : '');

        isNeed('manual_point') && (result.manual_point = dataVCard ? dataVCard.manual_point : '');

        isNeed('manual_bounds') && (result.manual_bounds = dataVCard ? dataVCard.manual_bounds : '');

        isNeed('metro') && (result.metro = dataVCard ? dataVCard.metro : '');

        isNeed('contact_email') && (result.contact_email = dataVCard ? dataVCard.contact_email : '');

        isNeed('im_client') && (result.im_client = dataVCard ? dataVCard.im_client : '');

        isNeed('im_login') && (result.im_login = dataVCard ? dataVCard.im_login : '');

        isNeed('extra_message') && (result.extra_message = dataVCard ? dataVCard.extra_message : '');

        isNeed('org_details_id') && (result.org_details_id = dataVCard ? dataVCard.org_details_id : '');

        isNeed('ogrn') && (result.ogrn = dataVCard ? dataVCard.ogrn : '');
        // Данные визитки необходимые для открытия попапа визитки - end

        isNeed('flags') &&
            (result.flags = u['b-banner-preview2'].filterFlagsWithSameParent(modelBanner.get('hash_flags')));

        isNeed('flagsSettings') && (result.flagsSettings = u['b-banner-preview2_type_dynamic'].getFlagsSettings({
            bid: +modelBanner.get('bid'),
            isCopyGroup: modelGroup.get('isCopyGroup'),
            isNewGroup: modelGroup.get('isNewGroup')
        }));

        isNeed('isArchived') && (result.isArchived = modelBanner.get('archive') == 'Yes');

        isNeed('geo') && modelGeo &&
            (result.geo = u['b-banner-preview2'].processGeo(modelGeo.get('geo'), modelGeo.get('geoText')));

        return result;
    },

    /**
     * Возвращает объект зависимостей полей view-модели от data-моделей
     * @returns {Object}
     * @private
     */
    _dependsFromDMs: function() {
        return {
            banner: {
                body: ['body'],
                has_vcard: ['vcard', 'phone', 'worktime', 'metro', 'city'],
                isVCardEmpty: ['vcard', 'phone', 'worktime', 'metro', 'city'],
                vcard: [
                    'country', 'city', 'country_code', 'city_code', 'phone', 'ext', 'name', 'contactperson',
                    'worktime', 'street', 'house', 'build', 'apart', 'auto_point', 'auto_bounds', 'auto_precision',
                    'manual_point', 'manual_bounds', 'metro', 'contact_email', 'im_client', 'im_login', 'extra_message',
                    'org_details_id', 'ogrn'
                ],
                loadVCardFromClient: ['vcard'],
                image_model: ['image', 'imageWidth', 'imageHeight', 'mdsGroupId'],
                sitelinks: ['sitelinks'],
                callouts: ['callouts'],
                archive: ['isArchived'],
                hash_flags: ['flags']
            },
            group: {
                main_domain: ['url', 'domain'],
                data_source: ['domain'],
                href_params: ['url', 'isHrefHasParams'],
                market_rating: ['rating']
            }
        };
    }
});
