u.register({

    'b-banner-preview2_type_image': {
        /**
         * Преобразует серверные данные баннера в формат блока b-banner-preview2
         * @param {Object} data параметры
         * @param {Object} data.banner Объект баннера
         * @param {Object} data.group Объект группы
         * @param {Object} [data.campaign] Объект кампании
         * @param {Object} [data.phrase] Объект фразы
         * @returns {Object}
         */
        fromServer: function(data) {
            var result = {},
                bannerData = data.banner,
                groupData = data.group,
                campaignData = data.campaign || {},
                phraseData = data.phrase,
                showTurbolanding = u.turbo.isGroupTypeSupported(groupData.adgroup_type, groupData.cpm_banners_type),
                isOpenStat = bannerData.statusOpenStat === 'Yes' || groupData.statusOpenStat === 'Yes' ||
                    campaignData.statusOpenStat === 'Yes';

            result.isArchived = bannerData.archive == 'Yes';

            result.imageAd = bannerData.image_ad;

            if (groupData.adgroup_type === 'cpm_yndx_frontpage') {
                bannerData.ad_type = 'cpm_yndx_frontpage';
            }
            result.adType = bannerData.ad_type;

            result.flags = u['b-banner-preview2'].filterFlagsWithSameParent(bannerData.hash_flags);

            result.disclaimer = bannerData.disclaimer;

            result.url = (u._.contains([
                'text',
                'mcbanner',
                'cpm_banner',
                'cpm_deals',
                'cpm_yndx_frontpage'
            ], groupData.adgroup_type)) ?
                u['b-banner-preview2_type_text'].getPreviewUrl({
                    isOpenStat: isOpenStat,
                    isClickTrack: !!(bannerData.status_click_track || campaignData.status_click_track),
                    bannerHrefData: {
                        href: bannerData.href,
                        url_protocol: bannerData.url_protocol
                    },
                    phrase: phraseData
                }) :
                u['b-banner-preview2_type_mobile-content'].getPreviewUrl({
                    isOpenStat: isOpenStat,
                    storeContentHref: groupData.store_content_href,
                    bannerHrefData: {
                        href: bannerData.href,
                        url_protocol: bannerData.url_protocol
                    }
                });

            result.creative = bannerData.creative;

            showTurbolanding && bannerData.turbolanding && (result.turbolanding = bannerData.turbolanding);
            showTurbolanding && bannerData.turbolandingGeoproduct &&
                (result.turbolanding = bannerData.turbolandingGeoproduct);

            result.cpmBannersType = groupData.cpm_banners_type;

            groupData.geo && (result.geo = u['b-banner-preview2']
               .processGeo(groupData.geo, groupData.geo_names, bannerData.geo_exception));

            return result;
        }
    }

});
