BEM.MODEL.decl({ model: 'b-banner-preview2_type_image', baseModel: 'b-banner-preview2' }, {

    imageAd: { type: 'object' },

    // Ссылка баннера
    url: { type: 'string' },

    creative: { type: 'object' },

    // Флаг о том, что объявление является архивным
    isArchived: { type: 'boolean' },

    // Объект с регионами
    geo: { type: 'object' },

    adType: {
        type: 'enum',
        enum: [
            'text',
            'image_ad',
            'cpc_video',
            'mcbanner',
            'cpm_banner',
            'cpm_yndx_frontpage',
            'cpm_deals',
            'cpm_price'
        ]
    },

    // Объект с предупреждениями из модерации (для отправки в pcode при проигрывании cpc_video)
    flags: {
        type: 'object',
        default: {}
    },

    // текстовый дисклеймер (для отправки в pcode при проигрывании cpc_video)
    disclaimer: { type: 'string' },

    // ссылка на турбо-страницу
    turbolanding: { type: 'object' },

    turbolanding_href_params: { type: 'string' },

    cpmBannersType: { type: 'string' }

}, {

    /**
     * Заполняет данными и инициализирует view-модель
     * @param {Object} ids Идентификаторы data-моделей
     * @param {String} ids.bannerId Идентификатор модели баннер
     * @param {String} ids.groupId Идентификатор модели группы
     * @param {String} [adgroupType]
     */
    init: function(ids, adgroupType) {
        var groupName = u.campaign.getGroupModelName(adgroupType),
            dmsParams = {
                banner: {
                    name: u.campaign.getBannerModelName(adgroupType),
                    id: ids.bannerId,
                    parentName: groupName,
                    parentId: ids.groupId
                },
                group: {
                    name: groupName,
                    id: ids.groupId
                }
            };

        this.set('_dmDecl', dmsParams);

        // Возвращает объект зависимостей полей view-модели от data-моделей
        // определяем на этапе иницализации, так как модель баннера может быть разной
        this._dependsFromDMs = function() {
            var depends = {
                banner: {
                    archive: ['isArchived'],
                    creative: ['creative'],
                    ad_type: ['adType']
                }
            };

            // Флаги из модерации нужны для отправки их в показывающий код при проигрывании cpc_video
            if (adgroupType === 'text') {
                depends.banner.hash_flags = ['flags'];
                depends.banner.disclaimer = ['disclaimer'];
            }

            if (u._.contains(['text', 'mcbanner', 'mobile_content'], adgroupType)) {
                depends.banner.image_ad = ['imageAd'];
            }

            if (u._.contains(['text', 'mcbanner', 'cpm_banner', 'cpm_deals', 'cpm_yndx_frontpage'], adgroupType)) {
                depends.banner.href_model = ['url'];
                depends.phrase = {
                    param1: ['url'],
                    param2: ['url']
                };
            } else {
                depends.banner.href = ['url'];
                depends.banner.url_protocol = ['url'];
                depends.group = {
                    store_content_href: ['url']
                }
            }

            switch (adgroupType) {
                case 'text':
                    depends.banner.turbolanding = ['turbolanding'];
                    break;
                case 'cpm_banner':
                    depends.banner.turbolanding = ['turbolanding'];
                    depends.banner.turbolandingGeoproduct = ['turbolandingGeoproduct'];
                    depends.group = {
                        cpmGroupType: ['turbolanding', 'turbolandingGeoproduct', 'cpmBannersType']
                    };
                    break;
            }

            return depends;
        };

        this.__base();
    },

    /**
     * Подготавливает данные для view-модели из объекта с data-моделями
     * @param {Object} dataModels объект с data-моделями
     * @param {String[]} required список полей, которые нужно получить. Если не передавать, то возвращает объект
     * со всеми полями
     * @returns {{}}
     */
    prepareDataFromDM: function(dataModels, required) {
        var result = {},
            turbo,
            modelBanner = dataModels.banner,
            modelGroup = dataModels.group,
            modelCampaign = modelGroup.getCampaignModel(),
            isNeed = this.getIsNeedFunction(required),
            modelGeo,
            bannerType = modelGroup.get('adgroup_type'),
            showTurbolanding = u.turbo.isGroupTypeSupported(bannerType, modelGroup.get('cpmGroupType')),
            isOpenStat = modelBanner.get('statusOpenStat') === 'Yes' || modelGroup.get('statusOpenStat') === 'Yes' ||
                modelCampaign.get('statusOpenStat') === 'Yes',
            isCpmGeoproduct = modelGroup.get('cpmGroupType') === 'cpm_geoproduct';

        isNeed('isArchived') && (result.isArchived = modelBanner.get('archive') === 'Yes');

        isNeed('adType') && (result.adType = modelBanner.get('ad_type'));

        isNeed('imageAd') && modelBanner.get('image_ad') && (result.imageAd = modelBanner.get('image_ad').toJSON());

        isNeed('creative') && (result.creative = modelBanner.get('creative').toJSON());

        isNeed('geo') && (modelGeo = modelGroup.getGeoModel()) &&
            (result.geo = u['b-banner-preview2'].processGeo(modelGeo.get('geo'), modelGeo.get('geoText')));

        isNeed('flags') &&
            (result.flags = u['b-banner-preview2'].filterFlagsWithSameParent(modelBanner.get('hash_flags')));

        isNeed('disclaimer') && (result.disclaimer = modelBanner.get('disclaimer'));

        if (isNeed('url')) {
            result.url = u._.contains(['text', 'mcbanner', 'cpm_banner', 'cpm_deals'], bannerType) ?
                u['b-banner-preview2_type_text'].getPreviewUrl({
                    isOpenStat: isOpenStat,
                    isClickTrack: modelBanner.get('status_click_track') || !!modelCampaign.get('status_click_track'),
                    bannerHrefData: {
                        href: modelBanner.get('href_model').get('href'),
                        url_protocol: modelBanner.get('href_model').get('url_protocol')
                    },
                    phrase: dataModels.phrase ? dataModels.phrase.toJSON() : {}
                }) :
                u['b-banner-preview2_type_mobile-content'].getPreviewUrl({
                    isOpenStat: isOpenStat,
                    storeContentHref: modelGroup.get('store_content_href'),
                    bannerHrefData: {
                        href: modelBanner.get('href'),
                        url_protocol: modelBanner.get('url_protocol')
                    }
                });
        }

        if (isNeed('turbolanding')) {
            turbo = modelBanner.get('turbolanding');

            result.turbolanding = showTurbolanding && turbo && turbo.provideData();
        }

        if (isCpmGeoproduct && isNeed('turbolandingGeoproduct')) {
            turbo = modelBanner.get('turbolandingGeoproduct');

            result.turbolanding = showTurbolanding && turbo && turbo.provideData();
        }

        isNeed('turbolanding_href_params') && (result.turbolanding_href_params = modelBanner.get('turbolanding_href_params'));

        isNeed('cpmBannersType') && (result.cpmBannersType = modelGroup.get('cpmGroupType'));

        return result;
    }
});
