u.register({

    'b-banner-preview2_type_mobile-content': {

        /**
         * Метод возвращает набор параметров для предупреждений из модерации, которые будут доступны в базовом виде
         * В других видах обычно возможностей изменения нет
         * @param {Object} obj
         * @param {Number} obj.bid bid баннера
         * @param {Object} obj.disclaimer Текстовое предупреждение
         * @param {Boolean} obj.isNewGroup Флаг новой группы
         * @param {Boolean} obj.isCopyGroup Флаг скопированной группы
         * @returns {Object}
         */
        getFlagsSettings: function(obj) {
            var bannerIsNew = obj.isNewGroup || obj.isCopyGroup || !obj.bid;

            return {
                // У нового баннера всегда есть предустановленное возрастное ограничение 18+, но менять не даём
                age: {
                    dontShow: u.consts('tld') == 'com.tr',
                    edit: bannerIsNew ? false : true,
                    addRemove: false
                },
                // Возможность редактировать есть у всех, добавлять удалять только у пользователей с правами супер
                other: {
                    dontShow: bannerIsNew,
                    edit: true,
                    addRemove: false
                }
            };
        },

        /**
         * Возвращает данные по мобильному контенту в случае незаполненной ссылки на магазин
         * @returns {
         *  {
         *      rating: number,
         *      ratingVotes: string,
         *      showIcon: boolean,
         *      showRatingVotes: boolean,
         *      showRating: boolean,
         *      publisherDomain: string
         *  }
         *  }
         */
        getEmptyStoreData: function() {
            return {
                rating: 0,
                ratingVotes: '000 000',

                showIcon: true,
                showRatingVotes: true,
                showRating: true,

                flagsSettings: u['b-banner-preview2_type_mobile-content'].getFlagsSettings({}),

                publisherDomain: ''
            };
        },

        /**
         * Преобразует серверные данные баннера в формат блока b-banner-preview2
         * @param {Object} data параметры
         * @param {Object} data.banner Объект баннера
         * @param {Object} data.group Объект группы
         * @param {Object} data.campaign Объект кампании
         * @param {Object} data.mobileContent Объект с данными по мобильному приложению
         * @param {Object} [data.phrase] Объект фразы
         * @returns {Object}
         */
        fromServer: function(data) {
            var result = {},
                bannerData = data.banner,
                groupData = data.group,
                phraseData = data.phrase,
                campaignData = data.campaign,
                mobileContentData = data.mobileContent || {},
                baseBannerPreviewUtils = u['b-banner-preview2'],
                storeNotDefined = !groupData.store_content_href,
                reflectedAttrs = bannerData.reflected_attrs || [],
                emptyStoreData = this.getEmptyStoreData();

            result.title = bannerData.title ?
                // форматирует заголовок баннера, эта же функция вызывается в m-banner.js
                u.preview.prettifyText(bannerData.title) :
                iget2('b-banner-preview2', 'zagolovok-obyavleniya', 'Заголовок объявления');

            // форматирует описание баннера, эта же функция вызывается в m-banner.js
            result.body = bannerData.body ?
                u.preview.prettifyText(bannerData.body) :
                iget2('b-banner-preview2', 'tekst-obyavleniya-o-vashem', 'Текст объявления о вашем мобильном приложении.');

            result.phrase = (phraseData || {}).key_words ? u.preview.formatPhrase(phraseData.key_words) : '';

            // при копировании группы bid в данных нет, поэтому задаем '0'
            result.bid = bannerData.bid || '0';

            result.cid = campaignData.cid;

            result.isTemplateBanner = !!bannerData.is_template_banner;

            result.flags = u['b-banner-preview2'].filterFlagsWithSameParent(bannerData.hash_flags);
            result.disclaimer = bannerData.disclaimer;

            result.flagsSettings = u['b-banner-preview2_type_mobile-content'].getFlagsSettings({
                bid: +bannerData.bid,
                isNewGroup: groupData.isNewGroup,
                isCopyGroup: groupData.isCopyGroup
            });

            result.isArchived = bannerData.archive == 'Yes';

            groupData.geo && (result.geo = baseBannerPreviewUtils
                .processGeo(groupData.geo, groupData.geo_names, bannerData.geo_exception));

            if (!storeNotDefined) {
                if (mobileContentData.prices) {
                    var actionPrice = mobileContentData.prices['download'];

                    if (actionPrice && +actionPrice.price) {
                        result.price = actionPrice.price;
                        result.currency = actionPrice.price_currency;
                    }
                }
            }

            bannerData.image && (result.image = bannerData.image);
            // РМП-изображения всегда широкоформатные
            // https://st.yandex-team.ru/DIRECT-68252
            result.image_type = 'wide';
            bannerData.image_width && (result.imageWidth = +bannerData.image_width);
            bannerData.image_height && (result.imageHeight = +bannerData.image_height);
            bannerData.mds_group_id && (result.mdsGroupId = bannerData.mds_group_id);

            result.videoExtension = !u._.isEmpty(bannerData.video_resources) && bannerData.video_resources;

            result.icon = storeNotDefined ? emptyStoreData.icon : mobileContentData.icon_url;

            result.rating = storeNotDefined ? emptyStoreData.rating : mobileContentData.rating;
            result.ratingVotes = storeNotDefined ? emptyStoreData.ratingVotes : mobileContentData.rating_votes &&
                u.numberFormatter.format(mobileContentData.rating_votes, { precision: 0 });

            result.url = u['b-banner-preview2_type_mobile-content'].getPreviewUrl({
                isOpenStat: bannerData.statusOpenStat == 'Yes' || groupData.statusOpenStat == 'Yes' ||
                    campaignData.statusOpenStat == 'Yes',
                storeContentHref: groupData.store_content_href,
                bannerHrefData: {
                    href: bannerData.href,
                    url_protocol: bannerData.url_protocol
                }
            });

            result.actionType = bannerData.primary_action;

            result.showRating = storeNotDefined ? emptyStoreData.showRating : reflectedAttrs.indexOf('rating') !== -1;
            result.showPrice = storeNotDefined ?
                emptyStoreData.showPrice :
                (reflectedAttrs.indexOf('price') !== -1 && !!u.currencies.get(result.currency));
            result.showIcon = storeNotDefined ? emptyStoreData.showIcon : reflectedAttrs.indexOf('icon') !== -1;
            result.showRatingVotes = storeNotDefined ?
                emptyStoreData.showRatingVotes :
                reflectedAttrs.indexOf('rating_votes') !== -1;

            result.publisherDomain = storeNotDefined ?
                emptyStoreData.publisherDomain :
                mobileContentData.publisher_domain;

            return result;
        },

        /**
         * Метод возвращает ссылку для превью
         * @param {Object} params параметры
         * @param {Boolean} params.isOpenStat
         * @param {String} params.storeContentHref
         * @param {Object} params.bannerHrefData
         * @param {String} params.bannerHrefData.href
         * @param {String} params.bannerHrefData.url_protocol
         * @returns {String}
         */
        getPreviewUrl: function(params) {
            var bannerHrefData = params.bannerHrefData,
                storeContentHref = params.storeContentHref,
                url;

            if (storeContentHref) {
                url = bannerHrefData.href ?
                    u.preview.prepareHref(bannerHrefData.href, bannerHrefData.url_protocol) :
                    storeContentHref;
            }

            return u.isUrl(url) ? u.formatHref(url, params.isOpenStat) : '#';
        }
    }

});
