BEM.MODEL.decl({ model: 'b-banner-preview2_type_mobile-content', baseModel: 'b-banner-preview2' }, {
    //ссылка, которая показывается на кнопке (результат обработки ссылки на стор и ссылки на треккинг)
    url: 'string',
    bid: 'string',
    icon: 'string',
    // Хэш картинки объявления
    image: 'string',

    // Ширина картинки объявления
    imageWidth: { type: 'number' },

    // Высота картинки объявления
    imageHeight: { type: 'number' },

    // Номер группы в Аватарнице
    mdsGroupId: { type: 'string' },

    // url изображения для превью при редактировании изображения
    previewUrl: 'string',

    // Видеодополнение
    videoExtension: { type: 'object' },

    //цена для данного приложения
    price: 'number',
    //валюта цены
    currency: 'string',

    //рейтинг приложения в сторе
    rating: 'number',
    //количество оценок приложения в сторе
    ratingVotes: 'string',

    //флаг "показывать рейтинг"
    showRating: 'boolean',
    //флаг "показывать кол-во оценок" (только если уже есть showRating)
    showRatingVotes: 'boolean',
    //показывать цену
    showPrice: 'boolean',
    //показывать иконку
    showIcon: 'boolean',
    //тип действия на кнопке
    actionType: 'string',

    title: 'string',
    body: 'string',
    phrase: 'string',
    // Флаг о наличие шаблона в баннере
    isTemplateBanner: {
        type: 'boolean',
        dependsFrom: ['title', 'body'],
        calculate: function() {
            return u.matchTemplate(this.get('body')) || u.matchTemplate(this.get('title'));
        }
    },

    // Флаг, что баннер новый
    isNewBanner: 'boolean',

    // Объект с регионами
    geo: { type: 'object' },

    // текстовый дисклеймер
    disclaimer: { type: 'string' },

    flags: {
        type: 'object',
        default: {}
    },

    // Настройки отображения и работы предупреждений из модерации
    flagsSettings: 'object',
    // Флаг о том, что объявление является архивным
    isArchived: { type: 'boolean' },

    // Идентификатор кампании
    cid: { type: 'string' },

    // домен разработчика
    publisherDomain: { type: 'string' }
}, {

    /**
     * Заполняет данными и инициализирует view-модель
     * @param {Object} ids Идентификаторы data-моделей
     * @param {String} ids.bannerId Идентификатор модели баннер
     * @param {String} ids.groupId Идентификатор модели группы
     * @param {String} ids.mobileContentId Идентификатор модели мобильного контента
     * @param {String} [ids.phraseId] Идентификатор модели фразы
     */
    init: function(ids) {
        var groupModelParams = { name: 'dm-mobile-content-group', id: ids.groupId },
            groupModel = BEM.MODEL.getOrCreate(groupModelParams),
            dmsParams = {
                banner: {
                    name: 'dm-mobile-content-banner',
                    id: ids.bannerId,
                    parentModel: groupModel
                },
                mobileContent: {
                    name: 'dm-mobile-content',
                    id: ids.mobileContentId,
                    parentModel: groupModel
                },
                group: groupModelParams
            };

        ids.phraseId && (dmsParams.phrase = {
            name: groupModel.get('isBidable') ? 'm-phrase-bidable' : 'm-phrase-text',
            id: ids.phraseId,
            parentModel: groupModel
        });

        this.set('_dmDecl', dmsParams);

        this.__base();
    },

    /**
     * Подготавливает данные для view-модели из объекта с data-моделями
     * @param {Object} dataModels объект с data-моделями
     * @param {String[]} required список полей, которые нужно получить. Если не передавать, то возвращает объект
     * со всеми полями
     * @returns {{}}
     */
    prepareDataFromDM: function(dataModels, required) {
        var result = {},
            mobileContentPreviewUtils = u['b-banner-preview2_type_mobile-content'],
            modelBanner = dataModels.banner,
            modelGroup = dataModels.group,
            modelMobileContent = dataModels.mobileContent,

            modelGeo = modelGroup.getGeoModel(),
            modelImage = modelBanner.get('image_model'),
            videoExtension = modelBanner.get('video_resources'),
            modelCampaign = modelGroup.getCampaignModel(),

            dataPhrase = dataModels.phrase ? dataModels.phrase.toJSON() : {},

            //в отличии от обычного баннера в РМП-баннере нет отдельной модели для урла - только поле
            href = modelBanner.get('href'),

            reflectedAttrs = modelBanner.get('reflected_attrs') || [],

            storeNotDefined = !modelGroup.get('store_content_href'),
            emptyStoreData = mobileContentPreviewUtils.getEmptyStoreData(),
            isOpenStat = modelBanner.get('statusOpenStat') === 'Yes' || modelGroup.get('statusOpenStat') === 'Yes' ||
                modelCampaign.get('statusOpenStat') === 'Yes',

            // для получения только нужных полей (required)
            isNeed = this.getIsNeedFunction(required);

        isNeed('cid') && (result.cid = modelCampaign.get('cid') || modelGroup.get('cid') || modelBanner.get('cid'));

        isNeed('bid') && (result.bid = modelBanner.get('bid'));

        isNeed('title') && (result.title = modelBanner.get('title') || iget2('b-banner-preview2', 'zagolovok-obyavleniya', 'Заголовок объявления'));

        isNeed('body') && (
            result.body = modelBanner.get('body') ?
                modelBanner.get('body') :
                iget2('b-banner-preview2', 'tekst-obyavleniya-o-vashem', 'Текст объявления о вашем мобильном приложении.')
        );

        isNeed('phrase') && (result.phrase = dataPhrase.key_words ? u.preview.formatPhrase(dataPhrase.key_words) : '');

        isNeed('isTemplateBanner') && (result.isTemplateBanner = modelBanner.get('isTemplateBanner') ||
            u.hasTemplateSymbols(modelBanner.get('body')) || u.hasTemplateSymbols(modelBanner.get('title')));

        isNeed('isNewBanner') && (result.isNewBanner = modelBanner.get('isNewBanner'));

        if (isNeed('price') && !storeNotDefined) {
            var prices = modelMobileContent.get('prices');

            if (prices) {
                var actionPrice = prices['download'];

                if (actionPrice && +actionPrice.price >= 0) {
                    result.price = actionPrice.price;
                    result.currency = actionPrice.price_currency;
                }
            }
        }

        isNeed('flags') &&
            (result.flags = u['b-banner-preview2'].filterFlagsWithSameParent(modelBanner.get('hash_flags')));

        isNeed('disclaimer') && (result.disclaimer = modelBanner.get('disclaimer'));
        isNeed('flagsSettings') &&
            (result.flagsSettings = u['b-banner-preview2_type_mobile-content'].getFlagsSettings({
                bid: +modelBanner.get('bid'),
                disclaimer: modelBanner.get('disclaimer'),
                isNewGroup: modelGroup.get('isNewGroup'),
                isCopyGroup: modelGroup.get('isCopyGroup')
            }));

        isNeed('isArchived') && (result.isArchived = modelBanner.get('archive') == 'Yes');

        modelGeo && (result.geo = u['b-banner-preview2'].processGeo(modelGeo.get('geo'), modelGeo.get('geoText')));

        isNeed('icon') && (result.icon = storeNotDefined ? emptyStoreData.icon : modelMobileContent.get('icon_url'));

        isNeed('image') && (result.image = modelImage.get('image'));

        isNeed('imageWidth') & (result.imageWidth = modelImage.get('image_width'));
        isNeed('imageHeight') & (result.imageHeight = modelImage.get('image_height'));
        isNeed('mdsGroupId') && (result.mdsGroupId = modelImage.get('mds_group_id'));

        if (isNeed('videoExtension')) {
            result.videoExtension = !u._.isEmpty(videoExtension) && videoExtension;
        }

        isNeed('actionType') && (result.actionType = modelBanner.get('primary_action'));

        isNeed('rating') && (result.rating = storeNotDefined ?
            emptyStoreData.rating :
            modelMobileContent.get('rating'));

        isNeed('ratingVotes') &&
            (result.ratingVotes = storeNotDefined ?
                emptyStoreData.ratingVotes :
                modelMobileContent.get('rating_votes') &&
                    u.numberFormatter.format(modelMobileContent.get('rating_votes'), { precision: 0 }));

        if (isNeed('url')) {
            result.url = u['b-banner-preview2_type_mobile-content'].getPreviewUrl({
                isOpenStat: isOpenStat,
                storeContentHref: modelGroup.get('store_content_href'),
                bannerHrefData: {
                    href: href,
                    url_protocol: modelBanner.get('url_protocol')
                }
            });
        }

        isNeed('showRating') && (result.showRating = storeNotDefined ?
            emptyStoreData.showRating :
            reflectedAttrs.indexOf('rating') !== -1);

        isNeed('showPrice') && (result.showPrice = storeNotDefined ?
            emptyStoreData.showPrice :
            (reflectedAttrs.indexOf('price') !== -1 &&
                modelMobileContent.get('isCurrencySupported')));

        isNeed('showIcon') && (result.showIcon = storeNotDefined ?
            emptyStoreData.showIcon :
            reflectedAttrs.indexOf('icon') !== -1);

        isNeed('showRatingVotes') && (result.showRatingVotes = storeNotDefined ?
            emptyStoreData.showRatingVotes :
            reflectedAttrs.indexOf('rating_votes') !== -1);

        if (isNeed('publisherDomain')) {
            // https://st.yandex-team.ru/DIRECT-96917
            // здесь пришлось вставлять такой костыль, чтобы оторвать домен для видео в РМП,
            // на стороне бэка это сделать не получится, сломаются видео для ТГО
            // Сам костыль приехал из-за того, что в модель mobileContent всегда приходит
            // publisherDomain
            if (modelGroup.get('adgroup_type') == 'mobile_content') {
                result.publisherDomain = '';
            } else {
                result.publisherDomain = storeNotDefined ?
                  emptyStoreData.publisherDomain :
                  modelMobileContent.get('publisher_domain');
            }
        }

        return result;
    },

    /**
     * Возвращает объект зависимостей полей view-модели от data-моделей
     * @returns {Object}
     * @private
     */
    _dependsFromDMs: function() {
        return {
            banner: {
                title: ['title'],
                body: ['body'],
                url_protocol: ['url'],
                href: ['url'],
                image_model: ['image', 'imageWidth', 'imageHeight', 'mdsGroupId'],
                is_template_banner: ['isTemplateBanner'],
                reflected_attrs: ['showRating', 'showPrice', 'showIcon', 'showRatingVotes'],
                hash_flags: ['flags'],
                disclaimer: ['disclaimer'],
                primary_action: ['actionType'],
                video_resources: ['videoExtension']
            },
            group: {
                store_content_href: [
                    'category', 'url',
                    'icon', 'rating', 'ratingVotes'
                ]
            },
            mobileContent: {
                category: ['category'],
                icon_url: ['icon'],
                prices: ['price'],
                rating: ['rating', 'ratingVotes'],
                rating_votes: ['ratingVotes', 'rating'],
                isCurrencySupported: ['showPrice']
            },
            phrase: {
                key_words: ['phrase']
            }
        }
    },

    /**
     * //@heliarian - b-banner-preview2_type_text.vm.js - подумать куда перенести
     * Инициализирует автоматическую синхронизацию dm -> vm
     * Требует указания зависимости _dependsFromDM в виде
     * _dependsFromDM: function() {
             return {
                 dm1: {
                     dmField1: ['vmField1'],
                     dmField2: ['vmField2']
                 },
                 dm2: {
                     dmField1: ['vmField1', 'vmField2', 'vmField3'],
                     dmField2: ['vmField3'],
                     dmField3: ['vmField5']
                 }
             }
         }

     */
    initAutoSync: function() {
        this.__base.apply(this, arguments);

        this.getDM().phrase && this.getDM().phrase
            .on('destruct', this._replacePhraseModel, this)
            .on('is_suspended', 'change', this._replaceSuspendedPhrase, this);
    },

    /*
     * Заменяет выключенную фразу
     * @private
     */
    _replaceSuspendedPhrase: function(e, data) {
        if (data.value) {
            this._replacePhraseModel();
        }
    },

    /**
     * //@heliarian - b-banner-preview2_type_text.vm.js - подумать куда перенести
     * Поменяет фразу на другую случайно выбранную из группы
     * @private
     */
    _replacePhraseModel: function() {
        var dms = this.getDM(),
            phraseModel = dms.group.getRandomActivePhraseModel();

        // отписываемся от слушания события удаления и выключения старой фразы
        dms.phrase
            .un('destruct', this._replacePhraseModel, this)
            .un('is_suspended', 'change', this._replaceSuspendedPhrase, this);

        phraseModel && this.changeDM('phrase', phraseModel);

        // подписываемся на событие удаления и выключения новой фразы
        this.getDM().phrase
            .on('destruct', this._replacePhraseModel, this)
            .on('is_suspended', 'change', this._replaceSuspendedPhrase, this);
    }

});
