u.register({

    'b-banner-preview2_type_performance': {

        /**
         * Преобразует серверные данные баннера в формат блока b-banner-preview2
         * @param {Object} data параметры
         * @param {Object} data.banner Объект баннера
         * @param {Object} data.group Объект группы
         * @param {Object} data.campaign Объект кампании
         * @returns {Object}
         */
        fromServer: function(data) {
            var bannerData = data.banner,
                groupData = data.group,
                campaignData = data.campaign,
                result = {};

            result.cid = campaignData.cid;

            result.bid = bannerData.bid || '0'; // 0 при копировании

            result.creative = bannerData.creative;

            groupData.geo && (result.geo = u['b-banner-preview2'].processGeo(
                groupData.geo,
                groupData.geo_names,
                bannerData.geo_exception)
            );

            return result;
        }

    }

});
