BEM.MODEL.decl({ model: 'b-banner-preview2_type_performance', baseModel: 'b-banner-preview2' }, {

    // Идентификатор кампании
    cid: { type: 'string' },

    // Идентификатор баннера
    bid: { type: 'string' },

    // Объект с регионами
    geo: { type: 'object' },

    // Объект креатива баннера
    creative: { type: 'object' }

}, {

    /**
     * Заполняет данными и инициализирует view-модель
     * @param {Object} ids Идентификаторы data-моделей
     * @param {String} ids.bannerId Идентификатор модели баннер
     * @param {String} ids.groupId Идентификатор модели группы
     */
    init: function(ids) {
        this.set('_dmDecl', {
            banner: {
                name: 'dm-dynamic-media-banner',
                id: ids.bannerId,
                parentName: 'dm-dynamic-media-group',
                parentId: ids.groupId
            },
            group: {
                name: 'dm-dynamic-media-group',
                id: ids.groupId
            }
        });

        this.__base();
    },

    /**
     * Подготавливает данные для view-модели из объекта с data-моделями
     * @param {Object} dataModels объект с data-моделями
     * @param {String[]} required список полей, которые нужно получить. Если не передавать, то возвращает объект
     * со всеми полями
     * @returns {{}}
     */
    prepareDataFromDM: function(dataModels, required) {
        var result = {},

            modelBanner = dataModels.banner,
            modelGroup = dataModels.group,

            modelGeo = modelGroup.getGeoModel(),
            modelCampaign = modelGroup.getCampaignModel(),

            // для получения только нужных полей (required)
            isNeed = this.getIsNeedFunction(required);

        isNeed('cid') && (result.cid = modelCampaign.get('cid'));

        isNeed('bid') && (result.bid = modelBanner.get('bid'));

        isNeed('creative') && (result.creative = modelBanner.get('creative').toJSON());

        isNeed('geo') && modelGeo &&
            (result.geo = u['b-banner-preview2'].processGeo(modelGeo.get('geo'), modelGeo.get('geoText')));

        return result;
    }

});
