u.register({

    'b-banner-preview2_type_text': {
        /**
         * Преобразует серверные данные баннера в формат блока b-banner-preview2
         * @param {Object} data параметры
         * @param {Object} data.banner Объект баннера
         * @param {Object} data.group Объект группы
         * @param {Object} data.campaign Объект кампании
         * @param {Object} [data.phrase] Объект фразы
         * @returns {Object}
         */
        fromServer: function(data) {
            var result = {},
                bannerData = data.banner,
                groupData = data.group,
                phraseData = data.phrase,
                campaignData = data.campaign || {},
                organizationData = data.organization,
                isOpenStat = bannerData.statusOpenStat == 'Yes' || groupData.statusOpenStat == 'Yes' ||
                    campaignData.statusOpenStat == 'Yes',
                baseBannerPreviewUtils = u['b-banner-preview2'];

            result.url = u['b-banner-preview2_type_text'].getPreviewUrl({
                isOpenStat: isOpenStat,
                isClickTrack: !!(bannerData.status_click_track || campaignData.status_click_track),
                bannerHrefData: {
                    href: bannerData.href,
                    url_protocol: bannerData.url_protocol
                },
                phrase: phraseData
            });

            result.title = bannerData.title ?
                // форматирует заголовок баннера, эта же функция вызывается в m-banner.js
                u.preview.prettifyText(bannerData.title) :
                iget2('b-banner-preview2', 'zagolovok-obyavleniya', 'Заголовок объявления');

            // форматирует второй заголовок баннера, эта же функция вызывается в m-banner.js
            result.titleExt = bannerData.title_extension ? u.preview.prettifyText(bannerData.title_extension) : '';

            result.body = bannerData.body ?
                // форматирует описание баннера, эта же функция вызывается в m-banner.js
                u.preview.prettifyText(bannerData.body) :
                iget2('b-banner-preview2', 'tekst-vashego-obyavleniya-o', 'Текст вашего объявления о рекламе услуги или товара.');

            result.phrase = (phraseData || {}).key_words ? u.preview.formatPhrase(phraseData.key_words) : '';

            // при копировании группы bid в данных нет, поэтому задаем '0'
            result.bid = bannerData.bid || '0';

            result.cid = campaignData.cid;

            result.isTemplateBanner = !!bannerData.is_template_banner ||
                u.hasTemplateSymbols(bannerData.body) ||
                u.hasTemplateSymbols(bannerData.title) ||
                u.hasTemplateSymbols(bannerData.display_href);

            result.isHrefHasParams = !!u.hasHrefParams(bannerData.href);

            var sitelinks = (bannerData.sitelinks || []).filter(function(sitelink) { return sitelink.title });

            sitelinks.length && (result.sitelinks = sitelinks.map(function(sitelink) {
                return {
                    title: sitelink.title,
                    url: u.formatHref(sitelink.href, isOpenStat),
                    description: sitelink.description || '',
                    turbolanding: sitelink.turbolanding
                };
            }));

            bannerData.image && (result.image = bannerData.image);
            bannerData.image_type && (result.image_type = bannerData.image_type);
            bannerData.image_width && (result.imageWidth = +bannerData.image_width);
            bannerData.image_height && (result.imageHeight = +bannerData.image_height);

            bannerData.mds_group_id && (result.mdsGroupId = bannerData.mds_group_id);

            bannerData.callouts && (result.callouts = bannerData.callouts);
            organizationData && (result.organization = organizationData);

            result.videoExtension = !u._.isEmpty(bannerData.video_resources) && bannerData.video_resources;

            result.domain = bannerData.domain;
            result.displayHref = bannerData.display_href;

            result.flags = u['b-banner-preview2'].filterFlagsWithSameParent(bannerData.hash_flags);
            result.disclaimer = bannerData.disclaimer;

            result.flagsSettings = u['b-banner-preview2_type_text'].getFlagsSettings({
                bid: +bannerData.bid,
                isNewGroup: groupData.isNewGroup,
                isCopyGroup: groupData.isCopyGroup
            });

            result.rating = bannerData.market_rating;

            result.loadVCardFromClient = bannerData.loadVCardFromClient;

            result.titleSubstituteOn = campaignData && !campaignData.no_title_substitute;

            result.isArchived = bannerData.archive == 'Yes';

            result.has_site = bannerData.has_site_enum === 'yes';

            groupData.geo && (result.geo = baseBannerPreviewUtils
                .processGeo(groupData.geo, groupData.geo_names, bannerData.geo_exception));

            bannerData.turbolanding && (result.turbolanding = bannerData.turbolanding);

            result.prefer_vcard_over_permalink = +bannerData.prefer_vcard_over_permalink;

            return u._.extend(baseBannerPreviewUtils.getVCard(bannerData), result);
        },

        /**
         * Метод возвращает набор параметров для предупреждений из модерации, которые будут доступны в базовом виде
         * В других видах обычно возможностей изменения нет
         * @param {Object} obj
         * @param {Number} obj.bid bid баннера
         * @param {Boolean} obj.isNewGroup Флаг новой группы
         * @param {Boolean} obj.isCopyGroup Флаг скопированной группы
         * @returns {Object}
         */
        getFlagsSettings: function(obj) {
            var isNewBanner = obj.isNewGroup || obj.isCopyGroup || !obj.bid;

            return {
                age: {
                    dontShow: isNewBanner || u.consts('tld') == 'com.tr',
                    edit: true,
                    addRemove: false
                },
                other: {
                    dontShow: isNewBanner,
                    edit: true,
                    addRemove: false
                }
            };
        },

        /**
         * Метод возвращает ссылку для превью
         * @param {Object} params параметры
         * @param {Boolean} params.isOpenStat
         * @param {Boolean} params.isClickTrack
         * @param {Object} params.bannerHrefData
         * @param {String} params.bannerHrefData.href
         * @param {String} params.bannerHrefData.url_protocol
         * @param {Object} [params.phrase] Объект фразы
         * @returns {String}
         */
        getPreviewUrl: function(params) {
            var hrefData = params.bannerHrefData,
                hrefExist = u.isUrl(hrefData.href),
                url = u.preview.prepareHref(hrefData.href, hrefData.url_protocol);

            return hrefExist && u.getPreviewUrl(
                url,
                u.getPreviewUrlParams(params.phrase, params.isOpenStat, params.isClickTrack)
            ) || '';
        }
    }

});
