BEM.MODEL.decl({ model: 'b-banner-preview2_type_text', baseModel: 'b-banner-preview2' }, {

    // Идентификатор кампании
    cid: { type: 'string' },

    // Идентификатор баннера
    bid: { type: 'string' },

    // Заголовок баннера
    title: { type: 'string' },

    // "Второй" Заголовок баннера
    titleExt: { type: 'string' },

    // Текст баннера
    body: { type: 'string' },

    // Ссылка баннера
    url: { type: 'string' },

    // Рейтинг магазина в маркете (если ссылка ведет на интернет-магазин), иначе '-1'
    rating: { type: 'string' },

    // Домен из ссылки
    domain: { type: 'string' },

    // Отображаемая ссылка в домене
    displayHref: { type: 'string' },

    // Флаг о наличие шаблона в баннере
    isTemplateBanner: { type: 'boolean' },

    // Флаг, что баннер новый
    isNewBanner: { type: 'boolean' },

    // Флаг о наличии шаблона или параметров в урле
    isHrefHasParams: { type: 'boolean' },

    // Хэш картинки объявления
    image: { type: 'string' },

    // Тип изображения (широкоформатное/обычное)
    image_type: { type: 'string' },

    // Ширина изображения
    imageWidth: { type: 'number' },

    // Высота изображения
    imageHeight: { type: 'number' },

    // язык баннера (для pcode)
    lang: { type: 'string' },

    // Номер группы в Аватарнице
    mdsGroupId: { type: 'string' },

    // Уточнения
    callouts: { type: 'array' },

    // Список быстрых ссылок
    sitelinks: { type: 'array' },

    // Видеодополнение
    videoExtension: { type: 'object' },

    // Данные для VCard - start
    // Флаг наличия ссылки на визитку
    vcard: { type: 'boolean' },

    // Флаг о необходимости открытия визитки из параметров модели
    loadVCardFromClient: { type: 'boolean' },

    // Страна
    country: { type: 'string' },

    // Город
    city: { type: 'string' },

    // Код города
    city_code: { type: 'string' },

    // Код страны
    country_code: { type: 'string' },

    // Телефон указанный в визитке
    phone: { type: 'string' },

    // Добавочный номер
    ext: { type: 'string' },

    // Название компании/ФИО
    name: { type: 'string' },

    // Контактное лицо
    contactperson: { type: 'string' },

    // Время работы указанное в визитке
    worktime: { type: 'string' },

    // Улица
    street: { type: 'string' },

    // Номер дома
    house: { type: 'string' },

    // Строение
    build: { type: 'string' },

    // Офис
    apart: { type: 'string' },

    // Автоматическая точка на карте
    auto_point: { type: 'string' },

    // Автоматические границы карты
    auto_bounds: { type: 'string' },

    // Автоматическая детализация
    auto_precision: { type: 'string' },

    // Заданная точка на карте
    manual_point: { type: 'string' },

    // Заданные границы карты
    manual_bounds: { type: 'string' },

    // Идентификатор станции метро
    metro: { type: 'string' },

    // Контактный email
    contact_email: { type: 'string' },

    // Тип ИМ
    im_client: { type: 'string' },

    // ИМ Логин
    im_login: { type: 'string' },

    // Подробнее о товаре/услуге
    extra_message: { type: 'string' },

    org_details_id: { type: 'string' },

    // ОГРН/ОГРНИП
    ogrn: { type: 'string' },
    // Данные для VCard - end

    // текстовый дисклеймер
    disclaimer: { type: 'string' },

    // Объект с предупреждениями из модерации
    flags: {
        type: 'object',
        default: {}
    },

    // Настройки отображения и работы предупреждений из модерации
    flagsSettings: { type: 'object' },

    // Объект с регионами
    geo: { type: 'object' },

    // Объект с данными организации Я.Справочника
    organization: { type: 'object' },

    // Случайно выбранная фраза
    phrase: { type: 'string' },

    // Флаг о необходимости подстановки части описания в заголовок для десктопного поиска
    titleSubstituteOn: { type: 'boolean' },

    // Флаг о том, что объявление является архивным
    isArchived: { type: 'boolean' },

    // ссылка на турбо-страницу
    turbolanding: { type: 'object' },

    turbolanding_href_params: { type: 'string' },

    has_site: { type: 'boolean' },

    prefer_vcard_over_permalink: { type: 'boolean' }

}, {

    /**
     * Заполняет данными и инициализирует view-модель
     * @param {Object} ids Идентификаторы data-моделей
     * @param {String} ids.bannerId Идентификатор модели баннер
     * @param {String} ids.groupId Идентификатор модели группы
     * @param {String} [ids.phraseId] Идентификатор модели фразы
     */
    init: function(ids) {
        var groupModelParams = { name: 'm-group', id: ids.groupId },
            bannerModelParams = {
                name: 'm-banner',
                id: ids.bannerId,
                parentName: 'm-group',
                parentId: ids.groupId
            },
            groupModel = BEM.MODEL.getOrCreate(groupModelParams),
            bannerModel = groupModel.get('banners').getById(ids.bannerId);

        if (!bannerModel) {
            bannerModel = BEM.MODEL.getOrCreate(bannerModelParams);
            groupModel.get('banners').add(bannerModel);
        }

        var permalink = bannerModel.get('permalink'),
            dmsParams = {
                banner: bannerModelParams,
                group: groupModelParams
            };

        ids.phraseId && (dmsParams.phrase = {
            name: groupModel.get('isBidable') ? 'm-phrase-bidable' : 'm-phrase-text',
            id: ids.phraseId,
            parentModel: groupModel
        });

        var permalinkModel = BEM.MODEL.getOrCreate({
                name: 'm-organization',
                id: permalink
            }),
            permalinkData = permalinkModel.toJSON();

        permalink && Boolean(permalinkData.profileUrl) && (dmsParams.organization = {
            name: 'm-organization',
            id: permalink
        });

        this.set('_dmDecl', dmsParams);

        this.__base();
    },

    /**
     * Подготавливает данные для view-модели из объекта с data-моделями
     * @param {Object} dataModels объект с data-моделями
     * @param {String[]} required список полей, которые нужно получить. Если не передавать, то возвращает объект
     * со всеми полями
     * @returns {{}}
     */
    prepareDataFromDM: function(dataModels, required) {

        var result = {},
            turbo,
            modelBanner = dataModels.banner,
            modelGroup = dataModels.group,
            modelOrganization = dataModels.organization,

            modelGeo = modelGroup.getGeoModel(),
            modelImage = modelBanner.get('image_model'),
            modelCampaign = modelGroup.getCampaignModel(),

            modelHref = modelBanner.get('href_model'),

            dataVCard = modelBanner.get('vcard'),

            dataPhrase = dataModels.phrase ? dataModels.phrase.toJSON() : {},

            sitelinksModelJson = modelBanner.get('sitelinks') && modelBanner.get('sitelinks').toJSON(),

            isOpenStat = modelBanner.get('statusOpenStat') === 'Yes' || modelGroup.get('statusOpenStat') === 'Yes' ||
                modelCampaign.get('statusOpenStat') === 'Yes',

            videoExtension = modelBanner.get('video_resources'),

            // для получения только нужных полей (required)
            isNeed = this.getIsNeedFunction(required),

            // добавить в url турбо-страницы дополнительные параметры, как для основной ссылки
            updateTurboLandingUrl = function(turbolanding) {
                if (turbolanding && turbolanding.href) {
                    turbolanding.href = u['b-banner-preview2_type_text'].getPreviewUrl({
                        isClickTrack: modelBanner.get('status_click_track') || !!modelCampaign.get('status_click_track'),
                        bannerHrefData: { href: turbolanding.href }
                    });
                }
            };

        isNeed('cid') && (result.cid = modelCampaign.get('cid') || modelGroup.get('cid') || modelBanner.get('cid'));

        isNeed('bid') && (result.bid = modelBanner.get('bid'));

        isNeed('url') && (result.url = u['b-banner-preview2_type_text'].getPreviewUrl({
            isOpenStat: isOpenStat,
            isClickTrack: modelBanner.get('status_click_track') || !!modelCampaign.get('status_click_track'),
            bannerHrefData: {
                href: modelHref.get('href'),
                url_protocol: modelHref.get('url_protocol')
            },
            phrase: dataPhrase
        }));

        isNeed('title') && (result.title = modelBanner.get('title') || iget2('b-banner-preview2', 'zagolovok-obyavleniya', 'Заголовок объявления'));
        isNeed('titleExt') && (result.titleExt = modelBanner.get('title_extension'));

        isNeed('body') && (result.body = modelBanner.get('body') ||
            iget2('b-banner-preview2', 'tekst-vashego-obyavleniya-o', 'Текст вашего объявления о рекламе услуги или товара.'));

        isNeed('phrase') && (result.phrase = dataPhrase.key_words ? u.preview.formatPhrase(dataPhrase.key_words) : '');

        isNeed('rating') && (result.rating = modelHref.get('market_rating'));

        isNeed('domain') && (result.domain = modelHref.get('domain') || modelHref.get('domain_redir'));
        isNeed('displayHref') && (result.displayHref = modelBanner.get('display_href'));

        isNeed('isTemplateBanner') && (result.isTemplateBanner = modelBanner.get('isTemplateBanner') ||
            u.hasTemplateSymbols(modelBanner.get('body')) ||
            u.hasTemplateSymbols(modelBanner.get('title')) ||
            u.hasTemplateSymbols(modelBanner.get('display_href')));

        isNeed('isNewBanner') && (result.isNewBanner = modelBanner.get('isNewBanner'));

        isNeed('isHrefHasParams') && (result.isHrefHasParams = modelHref.get('isHrefHasParams'));

        isNeed('callouts') && (result.callouts = modelBanner.get('callouts'));

        isNeed('image') && (result.image = modelImage.get('image'));
        isNeed('image_type') && (result.image_type = modelImage.get('image_type'));
        isNeed('imageWidth') && (result.imageWidth = modelImage.get('image_width'));
        isNeed('imageHeight') && (result.imageHeight = modelImage.get('image_height'));

        isNeed('lang') && (result.lang = modelBanner.get('lang'));
        isNeed('mdsGroupId') && (result.mdsGroupId = modelImage.get('mds_group_id'));

        isNeed('sitelinks') &&
            (result.sitelinks = u._.range(u.consts('SITELINKS_NUMBER')).reduce(function(sitelinks, index) {
                var title = sitelinksModelJson['title' + index];

                title && (sitelinks[index] = {
                    title: title,
                    url: u['b-banner-preview2'].formatSitelinkUrl(
                        sitelinksModelJson['href' + index],
                        sitelinksModelJson['url_protocol' + index],
                        isOpenStat),
                    description: sitelinksModelJson['description' + index],
                    turbolanding: sitelinksModelJson['turbolanding' + index].id !== '0' ?
                        sitelinksModelJson['turbolanding' + index] :
                        undefined
                });

                if (sitelinks[index]) {
                    updateTurboLandingUrl(sitelinks[index].turbolanding);
                }

                return sitelinks;
            }, []));

        if (isNeed('videoExtension')) {
            result.videoExtension = !u._.isEmpty(videoExtension) && videoExtension;
        }

        // Данные визитки необходимые для открытия попапа визитки - start
        isNeed('vcard') && (result.vcard = !!(modelBanner.get('has_vcard') && !modelBanner.get('isVCardEmpty')));

        isNeed('loadVCardFromClient') && (result.loadVCardFromClient = modelBanner.get('loadVCardFromClient'));

        isNeed('country') && (result.country = dataVCard ? dataVCard.country : '');

        isNeed('city') && (result.city = dataVCard ? dataVCard.city : '');

        isNeed('country_code') && (result.country_code = dataVCard ? dataVCard.country_code : '');

        isNeed('city_code') && (result.city_code = dataVCard ? dataVCard.city_code : '');

        isNeed('phone') && (result.phone = dataVCard ? dataVCard.phone : '');

        isNeed('ext') && (result.ext = dataVCard ? dataVCard.ext : '');

        isNeed('name') && (result.name = dataVCard ? dataVCard.name : '');

        isNeed('contactperson') && (result.contactperson = dataVCard ? dataVCard.contactperson : '');

        isNeed('worktime') && (result.worktime = dataVCard ? dataVCard.worktime : '');

        isNeed('street') && (result.street = dataVCard ? dataVCard.street : '');

        isNeed('house') && (result.house = dataVCard ? dataVCard.house : '');

        isNeed('build') && (result.build = dataVCard ? dataVCard.build : '');

        isNeed('apart') && (result.apart = dataVCard ? dataVCard.apart : '');

        isNeed('auto_point') && (result.auto_point = dataVCard ? dataVCard.auto_point : '');

        isNeed('auto_bounds') && (result.auto_bounds = dataVCard ? dataVCard.auto_bounds : '');

        isNeed('auto_precision') && (result.auto_precision = dataVCard ? dataVCard.auto_precision : '');

        isNeed('manual_point') && (result.manual_point = dataVCard ? dataVCard.manual_point : '');

        isNeed('manual_bounds') && (result.manual_bounds = dataVCard ? dataVCard.manual_bounds : '');

        isNeed('metro') && (result.metro = dataVCard ? dataVCard.metro : '');

        isNeed('contact_email') && (result.contact_email = dataVCard ? dataVCard.contact_email : '');

        isNeed('im_client') && (result.im_client = dataVCard ? dataVCard.im_client : '');

        isNeed('im_login') && (result.im_login = dataVCard ? dataVCard.im_login : '');

        isNeed('extra_message') && (result.extra_message = dataVCard ? dataVCard.extra_message : '');

        isNeed('org_details_id') && (result.org_details_id = dataVCard ? dataVCard.org_details_id : '');

        isNeed('ogrn') && (result.ogrn = dataVCard ? dataVCard.ogrn : '');
        // Данные визитки необходимые для открытия попапа визитки - end

        isNeed('flags') &&
            (result.flags = u['b-banner-preview2'].filterFlagsWithSameParent(modelBanner.get('hash_flags')));

        isNeed('disclaimer') && (result.disclaimer = modelBanner.get('disclaimer'));

        isNeed('flagsSettings') && (result.flagsSettings = u['b-banner-preview2_type_text'].getFlagsSettings({
            bid: +modelBanner.get('bid'),
            isCopyGroup: modelGroup.get('isCopyGroup'),
            isNewGroup: modelGroup.get('isNewGroup')
        }));

        isNeed('titleSubstituteOn') &&
            (result.titleSubstituteOn = !modelCampaign.get('no_title_substitute'));

        isNeed('isArchived') && (result.isArchived = modelBanner.get('archive') == 'Yes');

        if (isNeed('turbolanding')) {
            turbo = modelBanner.get('turbolanding').provideData();
            result.turbolanding = turbo;
            if (turbo) {
                updateTurboLandingUrl(result.turbolanding);
            }
        }

        isNeed('turbolanding_href_params') && (result.turbolanding_href_params = modelBanner.get('turbolanding_href_params'));

        modelGeo && (result.geo = u['b-banner-preview2'].processGeo(modelGeo.get('geo'), modelGeo.get('geoText')));

        isNeed('has_site') && (result.has_site = modelBanner.get('has_site'));

        modelOrganization && (result.organization = {
            profileUrl: modelOrganization.get('profileUrl'),
            workTime: modelOrganization.get('workTimes'),
            phone: modelOrganization.get('phone'),
            address: modelOrganization.get('address'),
            isOnline: modelOrganization.get('isOnline')
        });

        isNeed('prefer_vcard_over_permalink') && (result.prefer_vcard_over_permalink = modelBanner.get('prefer_vcard_over_permalink'));

        return result;
    },

    /**
     * Возвращает объект зависимостей полей view-модели от data-моделей
     * @returns {Object}
     * @private
     */
    _dependsFromDMs: function() {
        return {
            banner: {
                title: ['title', 'isTemplateBanner'],
                title_extension: ['titleExt'],
                body: ['body', 'isTemplateBanner'],
                href_model: ['url', 'domain', 'rating', 'isHrefHasParams'],
                has_vcard: ['vcard'],
                isVCardEmpty: ['vcard'],
                vcard: [
                    'country', 'city', 'country_code', 'city_code', 'phone', 'ext', 'name', 'contactperson',
                    'worktime', 'street', 'house', 'build', 'apart', 'auto_point', 'auto_bounds', 'auto_precision',
                    'manual_point', 'manual_bounds', 'metro', 'contact_email', 'im_client', 'im_login', 'extra_message',
                    'org_details_id', 'ogrn'
                ],
                loadVCardFromClient: ['loadVCardFromClient'],
                image_model: ['image','mdsGroupId', 'image_type', 'imageWidth', 'imageHeight'],
                sitelinks: ['sitelinks'],
                callouts: ['callouts'],
                video_resources: ['videoExtension'],
                archive: ['isArchived'],
                hash_flags: ['flags'],
                disclaimer: ['disclaimer'],
                display_href: ['domain', 'displayHref'],
                turbolanding: ['turbolanding'],
                turbolanding_href_params: ['turbolanding_href_params'],
                has_site: ['has_site'],
                prefer_vcard_over_permalink: ['prefer_vcard_over_permalink']
            },
            phrase: {
                key_words: ['phrase'],
                param1: ['url'],
                param2: ['url']
            }
        }
    },

    /**
     * Инициализирует автоматическую синхронизацию dm -> vm
     * Требует указания зависимости _dependsFromDM в виде
     * _dependsFromDM: function() {
             return {
                 dm1: {
                     dmField1: ['vmField1'],
                     dmField2: ['vmField2']
                 },
                 dm2: {
                     dmField1: ['vmField1', 'vmField2', 'vmField3'],
                     dmField2: ['vmField3'],
                     dmField3: ['vmField5']
                 }
             }
         }

     */
    initAutoSync: function() {
        this.__base.apply(this, arguments);

        this.getDM().phrase && this.getDM().phrase
            .on('destruct', this._replacePhraseModel, this)
            .on('is_suspended', 'change', this._replaceSuspendedPhrase, this);
    },

    /*
     * Заменяет выключенную фразу
     * @private
     */
    _replaceSuspendedPhrase: function(e, data) {
        if (data.value) {
            this._replacePhraseModel();
        }
    },

    /**
     * Поменяет фразу на другую случайно выбранную из группы
     * @private
     */
    _replacePhraseModel: function() {
        var dms = this.getDM(),
            phraseModel = dms.group.getRandomActivePhraseModel();

        // отписываемся от слушания события удаления старой фразы
        dms.phrase
            .un('destruct', this._replacePhraseModel, this)
            .un('is_suspended', 'change', this._replaceSuspendedPhrase, this);

        if (phraseModel) {
            this.changeDM('phrase', phraseModel);
            // подписываемся на событие удаление новой фразы
            this.getDM().phrase
                .on('destruct', this._replacePhraseModel, this)
                .on('is_suspended', 'change', this._replaceSuspendedPhrase, this);
        }
    }

});
