block('b-banner-preview2').mod('view', 'campaign')(

    def()(function() {
        return applyNext({
            showTitleExtension: !!(this.ctx.data.titleExt || '').length
        });
    }),

    content()([
        {
            elem: 'warning-template'
        },
        {
            elem: 'title'
        },
        {
            elem: 'body'
        },
        {
            elem: 'v-card'
        },
        {
            elem: 'domain'
        },
        {
            elem: 'disclaimer'
        },
        {
            elem: 'flags'
        },
        {
            elem: 'flag-age'
        },
        {
            elem: 'turbo-landings'
        },
        {
            elem: 'geo-names'
        },
        {
            elem: 'additions'
        }
    ]),

    elem('flag-age').match(function() {
        return this.ctxData.flagsSettings && !this.ctxData.flagsSettings.age.dontShow;
    }).def()(function() {
        var settings = this.ctxData.flagsSettings.age;

        return applyNext({
            'ctx.can': {
                edit: settings.edit,
                addRemove: settings.addRemove
            }
        });
    }),

    elem('flags').match(function() {
        return this.ctxData.flagsSettings && !this.ctxData.flagsSettings.other.dontShow;
    }).def()(function() {
        var settings = this.ctxData.flagsSettings.other;

        return applyNext({
            'ctx.can': {
                edit: settings.edit,
                addRemove: settings.addRemove
            }
        });
    }),

    elem('domain').content()(function() {
        var data = this.ctxData,
            domain = u['b-banner-preview2']
                .getDomainWithDisplayHref(data.domain, data.displayHref, data.phrase);

        return [
            u.escapeHTML(domain),
            { elem: 'domain-params' }
        ];
    }),

    elem('domain').match((function() {
        return !this.ctxData.domain;
    })).def()('')
);
