BEM.DOM.decl({ block: 'b-banner-preview2', modName: 'view', modVal: 'extended-base' }, {

    onSetMod: {

        /**
         * Обработчик вызывается только тогда, когда вид превью меняют с РСЯ на какой-то другой
         */
        view: function() {
            this.__base.apply(this, arguments);

            this.delMod('with-image');
        }

    },

    /**
     * Возвращает объект зависимостей элементов от входных данных
     * Слева название элемента, справа поля view-модели от которых зависит элемент
     * @returns {Object}
     * @private
     */
    _getElemsDepends: function() {
        return {
            title: ['title', 'url', 'vcard', 'phrase'],
            image: ['title', 'image'],
            body: ['body', 'phrase'],
            favicon: ['image', 'url'],
            sitelinks: ['sitelinks'],
            callouts: ['callouts'],
            domain: ['domain', 'vcard', 'displayHref'],
            'v-card': ['vcard'],
            flags: ['flags'],
            'flag-age': ['flags']
        };
    },

    /**
     * Возвращает строку с html-ем одного элемента либо всех внутренностей блока для текущего view
     * Доопределяется для изменения модификатора `_with-image`, который зависит от наличия картинки,
     * нужен только для вида РСЯ, от наличия картинки меняется ширина превью
     * @param {String} [elemName] Имя элемента
     * @returns {String}
     * @private
     */
    _generateHtml: function(elemName) {
        var result = this.__base.apply(this, arguments);

        (!elemName || elemName === 'image') && this.setMod('with-image', this.getViewModel().get('image') ? 'yes' : '');

        return result;
    }

});
