block('b-banner-preview2').mod('view', 'mobile-content-campaign')(
    content()([
        {
            elem: 'warning-template'
        },
        {
            elem: 'title'
        },
        {
            elem: 'body'
        },
        {
            elem: 'disclaimer'
        },
        {
            elem: 'flags'
        },
        {
            elem: 'flag-age'
        },
        {
            elem: 'geo-names'
        },
        {
            elem: 'additions'
        }
    ]),

    elem('flag-age').match(function() {
        return this.ctxData.flagsSettings && !this.ctxData.flagsSettings.age.dontShow;
    }).def()(function() {
        var settings = this.ctxData.flagsSettings.age;

        return applyNext({
            'ctx.can': {
                edit: settings.edit,
                addRemove: settings.addRemove
            }
        });
    }),

    elem('flags').match(function() {
        return this.ctxData.flagsSettings && !this.ctxData.flagsSettings.other.dontShow;
    }).def()(function() {
        var settings = this.ctxData.flagsSettings.other;

        return applyNext({
            'ctx.can': {
                edit: settings.edit,
                addRemove: settings.addRemove
            }
        });
    }),

    elem('body').content()(function() {
        return this.ctx.content || u.replaceTemplate(
            this.ctxData.body,
            u['b-banner-preview2'].calcLimitWithNarrows(
                this.ctxData.body,
                +u.consts('MAX_BODY_LENGTH_MOBILE'),
                u.consts('NARROW_SYMBOLS')
            ),
            this.ctxData.phrase,
            'b-banner-preview2__template');
    }),

    elem('title').content()(function() {
        return {
            block: 'link',
            mix: [{
                block: 'b-banner-preview2',
                elem: 'title-link'
            }],
            url: this.ctxData.customTitleUrl || this.ctxData.url,
            target: '_blank',
            content: this.ctx.content || u.replaceTemplate(
                this.ctxData.title,
                u.consts('NEW_MAX_TITLE_LENGTH_MOBILE'),
                this.ctxData.phrase,
                'b-banner-preview2__template')
        };
    })
);
