BEM.DOM.decl({ block: 'b-banner-preview2', modName: 'view', modVal: 'mobile-content-partner-poster' }, {

    /**
     * Обработчик изменений полей модели баннера
     * @param {jQuery.Event} e
     * @param {Object} data
     * @param {Array} data.changedFields Список измененных полей
     * @param {Boolean} [data.inited] Флаг говорящий о том, что `change` произошел из-за инициализации модели
     * @private
     */
    _onModelsChange: function(e, data) {
        if (this._getNeedRepaintElemsList(data.changedFields).indexOf('partner-code') != -1) {
            this.setMod('with-image', this.getViewModel().get('image') ? 'yes' : '');
            this._updatePartnerCodePreview();
        }
    },

    /**
     * Обновляет баннер партнерского кода
     * @private
     */
    _updatePartnerCodePreview: function() {
        this.elemInstance('partner-code').update();
    },

    /**
     * Возвращает объект зависимостей элементов от входных данных
     * Слева название элемента, справа поля view-модели от которых зависит элемент
     * @returns {Object}
     * @private
     */
    _getElemsDepends: function() {
        // В сетях постер перерисовывается полностью при изменения следующих полей
        return {
            'partner-code': [
                'title',
                'body',
                'phrase',
                'url',
                'image',
                'imageHeight',
                'imageWidth',
                'mdsGroupId',
                'previewUrl',
                'icon',
                'showIcon',
                'price',
                'showPrice',
                'rating',
                'ratingVotes',
                'showRating',
                'showRatingVotes',
                'flags',
                'flagsSettings',
                'actionType'
            ]
        }
    }

});
