block('b-banner-preview2').mod('view', 'mobile-content-search')(
    mix()(function() {
        return {
            block: 'b-banner-preview2',
            mods: { 'show-icon': this.ctxData.showIcon ? 'yes' : '' }
        };
    }),

    content()([
        {
            elem: 'warning-template'
        },
        {
            elem: 'title'
        },
        {
            elem: 'mobile-content-icon'
        },
        {
            elem: 'body-wrapper',
            content: [
                {
                    elem: 'body'
                },
                {
                    elem: 'action-button'
                },
                {
                    elem: 'mobile-content-rating'
                }
            ]
        },
        {
            elem: 'disclaimer'
        },
        {
            elem: 'flags'
        },
        {
            elem: 'flag-age'
        }
    ]),

    elem('body').content()(function() {
        return this.ctx.content || u.replaceTemplate(
            this.ctxData.body,
            u['b-banner-preview2'].calcLimitWithNarrows(
                this.ctxData.body,
                +u.consts('MAX_BODY_LENGTH_MOBILE'),
                u.consts('NARROW_SYMBOLS')
            ),
            this.ctxData.phrase,
            'b-banner-preview2__template');
    }),

    elem('title').content()(function() {
        return {
            block: 'link',
            mix: [{
                block: 'b-banner-preview2',
                elem: 'title-link'
            }],
            url: this.ctxData.customTitleUrl || this.ctxData.url,
            target: '_blank',
            content: this.ctx.content || u.replaceTemplate(
                this.ctxData.title,
                u.consts('NEW_MAX_TITLE_LENGTH_MOBILE'),
                this.ctxData.phrase,
                'b-banner-preview2__template')
        };
    })

);
