BEM.DOM.decl({ block: 'b-banner-preview2', modName: 'view', modVal: 'mobile-content-search' }, {
    /**
     * Обработчик изменений полей модели баннера
     * Вызывает перерисовку превью
     * @param {jQuery.Event} e
     * @param {Object} data
     * @param {Array.<string>} data.changedFields Список измененных полей
     * @param {Boolean} [data.isInit] Флаг говорящий о том, что `change` произошел из-за инициализации модели
     * @override {b-banner-preview2_repaint_yes}
     * @private
     */
    _onModelsChange: function(e, data) {
        this.__base.apply(this, arguments);
        data.changedFields.indexOf('showIcon') !== -1 &&
            this.setMod('show-icon', this._viewModel.get('showIcon') ? 'yes' : 'no');
    },

    /**
     * Возвращает объект зависимостей элементов от входных данных
     * Слева название элемента, справа поля view-модели от которых зависит элемент
     * @returns {Object}
     * @private
     */
    _getElemsDepends: function() {
        return {
            title: ['title', 'url', 'phrase'],
            body: ['body', 'phrase'],
            'mobile-content-icon': ['url', 'icon', 'showIcon'],
            'action-button': ['url', 'showPrice', 'price', 'currency', 'actionType'],
            'mobile-content-rating': [
                'url', 'showRating', 'rating', 'showRatingVotes', 'ratingVotes'
            ],
            'warning-template': ['isTemplateBanner'],
            flags: ['flags', 'flagsSettings'],
            'flag-age': ['flags', 'flagsSettings']
        };
    }
});
