BEM.DOM.decl({ block: 'b-banner-preview2', modName: 'view', modVal: 'partner' }, {

    onSetMod: {

        /**
         * Обработчик вызывается только тогда, когда вид превью меняют с РСЯ на какой-то другой
         */
        view: function() {
            this.__base.apply(this, arguments);

            this.delMod('with-image');
        }

    },

    /**
     * Возвращает объект зависимостей элементов от входных данных
     * Слева название элемента, справа поля view-модели от которых зависит элемент
     * @returns {Object}
     * @private
     */
    _getElemsDepends: function() {
        // В сетях постер перерисовывается полностью при изменения следующих полей
        return {
            'partner-code': [
                'title', 'body', 'image', 'image_type',
                'imageHeight', 'imageWidth','mdsGroupId',
                'sitelinks', 'url', 'domain',
                'vcard', 'phrase', 'flags', 'callouts'
            ]
        };
    },

    /**
     * Обработчик изменений полей модели баннера
     * @param {jQuery.Event} e
     * @param {Object} data
     * @param {Array} data.changedFields Список измененных полей
     * @param {Boolean} [data.inited] Флаг говорящий о том, что `change` произошел из-за инициализации модели
     * @private
     */
    _onModelsChange: function(e, data) {
        if (this._getNeedRepaintElemsList(data.changedFields).indexOf('partner-code') != -1) {
            this.setMod('with-image', this.getViewModel().get('image') ? 'yes' : '');
            this._updatePartnerCodePreview();
        }
    },

    /**
     * Обновляет баннер партнерского кода
     * @private
     */
    _updatePartnerCodePreview: function() {
        this.elemInstance('partner-code').update();
    },

    /**
     * Возвращает строку с html-ем всех элементов блока для текущего view
     * Доопределяется для изменения модификатора `_with-image`, который зависит от наличия картинки,
     * нужен только для вида РСЯ, от наличия картинки меняется ширина превью
     * @param {String} [elemName] Имя элемента
     * @returns {String}
     * @private
     */
    _generateHtml: function(elemName) {
        var result = this.__base.apply(this, arguments);

        this.setMod('with-image', this.getViewModel().get('image') ? 'yes' : '');

        return result;
    }

});
