/**
 * на serp ведется работа, что бы предоставить API для создания превью
 * johnson@todo https://st.yandex-team.ru/SERP-50974
 */
block('b-banner-preview2').mod('view', 'search-desktop-target')(
    /*
        * @param {Boolean} {this.isTitleSubstitutionView} нужна ли в конкретном _view подстановка части тела объявления в заголовок
    */
    def()(function() {
        var sitelinks = u._.compact(this.ctx.data.sitelinks || []),
            targetView = sitelinks.length == u.consts('SITELINKS_NUMBER') && sitelinks.every(function(sitelink) {
                return sitelink.description;
            }),
            isTitleExtensionFilled = !!this.ctx.data.titleExt,
            showTitleExtension = false;

        if (isTitleExtensionFilled) {
            var separator = u.preview['TITLE_SENTENCE_SEPARATOR'],
                title = u.replaceTemplate(
                    this.ctx.data.title,
                    u['b-banner-preview2'].calcTitleTemplateLimit(this.ctx.data.title),
                    this.ctx.data.phrase,
                    null
                ),
                titleExt = u.replaceTemplate(
                    this.ctx.data.titleExt,
                    u['b-banner-preview2'].calcTitleExtTemplateLimit(this.ctx.data.titleExt),
                    this.ctx.data.phrase,
                    null
                ),
                fullTitle = [title, titleExt].join(separator);

            // https://st.yandex-team.ru/BSSERVER-3043 - по правилам ширина заголовка не должна привышать 536px
            showTitleExtension = u.charLength.getLength(fullTitle, 'arial', '18') <= 517;
        }

        return applyNext({
            targetView: targetView,
            isTitleSubstitutionView: !showTitleExtension,
            showTitleExtension: showTitleExtension,
            lengthMetaLine: u['b-banner-preview2'].calcContactsTotalLength(this.ctx.data, 64)
        });
    }),

    /**
     * @param {Number} ctx.lengthMetaLine кол-во символов в строке: №телефона+город+время+метро
     */
    content()(function() {
        var
            /**
             * @const
             * максимальная длинна строки в превью на поиске, номер телефона+город+время+метро
             */
            MAX_LENGTH_META_LINE = 64,
            /**
             * есть рейтинг магазина на маркете
             * @type {boolean}
             */
            hasRaiting = !!this.ctxData.rating && this.ctxData.rating !== -1,
            /**
             *
             * @type {boolean}
             */
            hasDisclaimer = !!this.ctxData.disclaimer,
            /**
             * Есть флаги (посоветуйтесь с врачом, оружие ....)
             * @type {boolean}
             */
            hasFlags = !u._.isEmpty(this.ctxData.flags) &&
                (u._.keys(this.ctxData.flags).length >= 2 || !this.ctxData.flags.age),
            /**
             * Есть возврастное ограничение
             * @type {boolean}
             */
            hasFlagAge = this.ctxData.flags && this.ctxData.flags.age,
            /**
             * Флаг нет превышения кол-ва символов в строке с данными MAX_LENGTH_META_LINE
             * @type {boolean}
             */
            isNormLenghtMetaLine = this.lengthMetaLine < MAX_LENGTH_META_LINE,
            /**
             * Нужно ли показывать метро и город
             * DIRECT-58340 метро и город показываем только если нет уточнений, либо есть уточнения, но суммарная длина телефон+город+время работы + метро < 64
             * @type {boolean}
             */
            hasMetroAndCity = !this.ctx.data.callouts || !this.ctx.data.callouts.length || isNormLenghtMetaLine,
            /**
             * Номер строки мета-данных, на которой, показать метро и город
             * @type {Number}
             */
            numLineForMetroAndCity = hasMetroAndCity ?
                (!hasRaiting && !hasDisclaimer && isNormLenghtMetaLine ? 1 : 2) : 0;

        return [
            { elem: 'favicon' },
            { elem: 'title' },
            { elem: 'sitelinks' },
            { elem: 'target-sitelinks' },
            {
                elem: 'domain-vcard-holder',
                content: [
                    { elem: 'domain' },
                    { elem: 'adv', content: iget2('b-banner-preview2', 'reklama', 'Реклама') }
                ]
            },
            { elem: 'body' },
            { elem: 'callouts' },

            /*
             * --FIRST LINE METADATA--
             * 'v-card'         : hard
             * 'phone'          : hard
             * 'worktime'       : hard
             * 'flag-age'       : hard
             * 'metro-and-city' : нет рейтинга маркета
             *                      <<И>> нет 'disclamer'
             *                      <<И>> нужно показать (hasMetroAndCity === true)
             *                      <<И>> длинна строки метаданных не превышает ~~64
             * 'disclamer'      : hard
             */
            {
                elem: 'meta-line',
                content: [
                    { elem: 'v-card' },
                    { elem: 'phone' },
                    { elem: 'worktime' },
                    hasFlagAge && { elem: 'flag-age' },
                    numLineForMetroAndCity === 1 && { elem: 'metro-and-city' },
                    { elem: 'disclaimer' }
                ]
            },

            /*
             * --SECOND LINE METADATA--
             *
             * условие показа второй строки метаданных:
             *     есть рейтинг магазина на маркете
             *     <<ИЛИ>>
             *     есть флаги //сообщение о вреде, оружии и т.д. //
             *     <<ИЛИ>>
             *     на первой строке метаданных не уместилась вся инфа (телефон, метро, город, режим работы) ~~ 64 символа
             *
             *
             * 'rating'         : hard
             * 'metro-and-city' : нужно показать (hasMetroAndCity === true)
             *                      <<И>> они не было показано в первой строке
             * 'flags'          : hard
             *
             */
            (hasRaiting || hasFlags || (!isNormLenghtMetaLine && hasMetroAndCity)) && {
                elem: 'meta-line',
                elemMods: { contains: 'flags' },
                content: [
                    { elem: 'rating' },
                    numLineForMetroAndCity === 2 && { elem: 'metro-and-city' },
                    hasFlags && {
                        elem: 'flags',
                        mix: [
                            { elem: 'meta-item-without-separator' }
                        ]
                    }
                ]
            }
        ];
    }),

    // убираем www из домена и не показываем значок шаблона
    elem('domain').content()(function() {
        var data = this.ctxData,
            maxLength = data.displayHref ? 56 : undefined, // 56 - если задана отображаемая ссылка, DIRECT-53551
            domain = u['b-banner-preview2']
                .getDomainWithDisplayHref(u.stripWww(data.domain), data.displayHref, data.phrase, maxLength);

        return u.escapeHTML(domain);
    }),

    elem('domain').match((function() {
        return !this.ctxData.domain;
    })).def()(''),

    // обрезаем до 64 символов
    elem('worktime').content()(function() {
        return u.hellipCut(applyNext(), 64);
    }),

    elem('v-card').def()(function() {
        return applyNext({
            'ctx.content': iget2('b-banner-preview2', 'kontaktnaya-informaciya', 'Контактная информация')
        });
    }),

    elem('metro-and-city')(replace()([
        { elem: 'metro' },
        { elem: 'city' }
    ])),

    elem('sitelinks').match(function() {
        return this.targetView;
    }).def()(''),

    elem('target-sitelinks').match(function() {
        return !this.targetView;
    }).def()('')
);
