BEM.DOM.decl({ block: 'b-banner-preview2', modName: 'view', modVal: 'search-desktop-target' }, {

    /**
     * Возвращает объект зависимостей элементов от входных данных
     * @returns {Object}
     * @private
     */
    _getElemsDepends: function() {

        return {
            title: ['title', 'body', 'url', 'domain', 'vcard', 'phrase', 'titleExt'],
            body: ['title', 'titleExt', 'body', 'phrase'],
            favicon: ['url'],
            rating: ['rating'],
            domain: ['domain', 'vcard', 'displayHref'],
            'v-card': ['vcard'],
            phone: ['phone', 'country_code', 'country_code', 'ext', 'vcard'],
            worktime: ['worktime'],
            callouts: ['callouts'],
            sitelinks: ['sitelinks'],
            'target-sitelinks': ['sitelinks'],
            metro: ['metro'],
            city: ['city'],
            flags: ['flags'],
            'flag-age': ['flags']
        };
    },

    /**
     * Если в списке встретился элемент со значением true то перерисовывает блок целиком
     * @param {Array} elemsName Список элементов, из-за которых нужна перерисовка
     * @private
     */
    _repaintElems: function(elemsName) {
        if (!(elemsName || []).length) return;

        elemsName.some(function(elem) { return elem === true; }) ?
            BEM.DOM.update(this.domElem, this._generateHtmlAllElems()) :
            this.__base.apply(this, arguments);
    }

});
