block('b-banner-preview2').mod('view', 'search-mobile-target')(
    /*
        * @param {Boolean} {this.isTitleSubstitutionView} нужна ли в конкретном _view подстановка части тела объявления в заголовок
    */
    def()(function() {
        return applyNext({
            isSearchMobile: true,
            isTitleSubstitutionView: !this.ctx.data.titleExt,
            showTitleExtension: !!this.ctx.data.titleExt
        });
    }),
    content()(function() {
        return {
            elem: 'wrapper',
            content: [
                {
                    elem: 'title'
                },
                {
                    elem: 'domain-holder',
                    content: [
                        {
                            elem: 'domain'
                        },
                        {
                            elem: 'adv',
                            content: iget2('b-banner-preview2', 'reklama', 'Реклама')
                        }
                    ]
                },
                {
                    elem: 'body-v-card-wrapper',
                    content: [
                        {
                            elem: 'body'
                        },
                        {
                            elem: 'v-card'
                        }
                    ]
                },
                {
                    elem: 'flag-age'
                },
                {
                    elem: 'disclaimer'
                },
                {
                    elem: 'flags'
                },
                {
                    elem: 'sitelinks'
                }
            ]
        };
    }),

    // убираем www из домена и не показываем значок шаблона
    elem('domain').content()(function() {
        var data = this.ctxData,
            domain = u['b-banner-preview2']
                .getDomainWithDisplayHref(u.stripWww(data.domain), '', data.phrase, 32);

        return u.escapeHTML(domain);
    }),

    elem('domain').match((function() {
        return !this.ctxData.domain;
    })).def()(''),

    elem('v-card').def()(function() {
        return this.ctxData.vcard ?
            applyCtx({
                elem: 'v-card-wrapper',
                content: {
                    elem: 'v-card-icon'
                }
            }) :
            '';
    }),

    elem('sitelinks')(

        match(function() {
            return u._.compact(this.ctxData.sitelinks || []).length != u.consts('SITELINKS_NUMBER');
        }).def()(''),

        content()(function() {
            return this.ctxData.sitelinks.map(function(sitelink) {
                var url = sitelink.url;
                if (u._.get(sitelink, 'turbolanding.id', '0') !== '0') {
                    url = sitelink.turbolanding.href;
                }
                return {
                    block: 'b-banner-preview2',
                    elem: 'sitelink',
                    url: url,
                    title: sitelink.title
                };
            }, this);
        })
    )

);
