block('b-banner-preview2')(

    /**
     * @param {Object} this.ctx.data Объект с данными по баннеру
     * @param {String} [this.ctx.data.cid] Идентификатор кампании
     * @param {String} [this.ctx.data.bid] Идентификатор баннера
     * @param {String} [this.ctx.data.title] Заголовок
     * @param {String} [this.ctx.data.titleExt] Заголовок2
     * @param {String} [this.ctx.data.body] Описание
     * @param {String} [this.ctx.data.url] Урл
     * @param {String} [this.ctx.data.rating] Рейтинг магазина в маркете
     * @param {String} [this.ctx.data.domain] домен
     * @param {Boolean} [this.ctx.data.isTemplateBanner] Флаг о том, что в баннере есть шаблон.
     * @param {Boolean} [this.ctx.data.isHrefHasParams] Флаг о том, что в урле есть шаблон или параметры.
     * @param {Boolean} [this.ctx.data.vcard] Наличие визитки
     * @param {Boolean} [this.ctx.data.isOpenStat] Флаг о необходимости добавлять в ссылку параметр _openstat
     * @param {String} [this.ctx.data.image] Хеш картинки
     * @param {String} [this.ctx.data.image_type] Тип картинки
     * @param {String} [this.ctx.data.imageWidth] Ширина картинки
     * @param {String} [this.ctx.data.imageHeight] Высота картинки
     * @param {Object[]} [this.ctx.data.sitelinks] Массив с быстрыми ссылками
     * @param {Object[]} [this.ctx.data.sitelinks[].title] Заголовок быстрой ссылки
     * @param {Object[]} [this.ctx.data.sitelinks[].url] Урл быстрой ссылки
     * @param {VideoExtension} [this.ctx.data.videoExtension] видеодополнение
     * @param {String} [this.ctx.data.phone] Телефон
     * @param {String} [this.ctx.data.worktime] Время работы
     * @param {String} [this.ctx.data.flags] Предупреждения
     * @param {Object} [this.ctx.data.geo]
     * @param {Number} [this.ctx.data.geo.count] Количество отображаемых регионов
     * @param {String} [this.ctx.data.geo.names] Сами регионы
     * @param {Object} [this.ctx.data.geo.exceptions] Исключения регионов
     * @param {Object} [this.ctx.staticData] Объект, которым будут переопределяться входные данные для блока,
     * даже после изменения зависимых полей data-моделей
     */
    def()(

        match(function() {
            return this.ctx._onlyContent;
        })(

            // для перерисовки внутренностей блока
            match(function() {
                return true;
            })(function() {
                return applyCtx(apply('content'));
            }),

            // для перерисовки конкретного элемента
            // пример вызова b-banner-preview2_repaint_yes.js, метод _getHtml()
            match(function() {
                return this.ctx.content;
            })(function() {
                return applyCtx(this.ctx.content);
            })
        ),

        match(function() {
            return true;
        })(function() {
            return applyNext({
                ctxData: this.ctx.staticData ?
                    u.deepExtend(this.ctx.data, this.ctx.staticData) : this.ctx.data,
                modelsParams: this.ctx.modelsParams
            });
        }),

        /*
        * @param {Boolean} {this.isTitleSubstitutionView} нужна ли в конкретном _view подстановка части тела объявления в заголовок
        */
        match(function() { return this.isTitleSubstitutionView; })
            .match(function() { return (this.ctx.data || {}).titleSubstituteOn; })
            .match(function() { return (this.ctx.data || {}).title; })
            .match(function() { return (this.ctx.data || {}).body; })(function() {
                var ctxData = this.ctx.data,
                    title = u.replaceTemplate(
                        ctxData.title,
                        u['b-banner-preview2'].calcTitleTemplateLimit(ctxData.title),
                        ctxData.phrase,
                        null,
                        true
                    ),
                    body = u.replaceTemplate(
                        ctxData.body,
                        u['b-banner-preview2'].calcBodyTemplateLimit(ctxData.body),
                        ctxData.phrase,
                        null,
                        true
                    ),
                    domain = ctxData.domain;

                return applyNext({
                    _substitution: u.preview.serpTitleSubstitution(title, body, domain)
                });
            })
     ),

    js()(function() {
        return {
            modelsParams: this.modelsParams,
            staticData: this.ctx.staticData
        };
    }),

    match(function() {
        return this._substitution;
    })(
        elem('title').def()(function() {
            return applyNext({
                'ctx.content': u.escapeHTML(this._substitution.title)
            });
        }),

        elem('body').def()(function() {
            return applyNext({
                'ctx.content': u.escapeHTML(this._substitution.body)
            });
        })
    )
);
